/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.seam.deployment.DeploymentHandler;
import org.jboss.seam.deployment.Scanner;
import org.jboss.seam.deployment.URLScanner;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeploymentStrategy {
    private static final LogProvider log = Logging.getLogProvider(DeploymentStrategy.class);
    private Scanner scanner;
    private List<File> files = new ArrayList<File>();
    private Map<String, DeploymentHandler> deploymentHandlers;
    public static final String SCANNERS_KEY = "org.jboss.seam.deployment.scanners";
    public static final String RESOURCE_BUNDLE = "META-INF/seam-deployment.properties";
    private static final String[] RESOURCE_BUNDLES = new String[]{"META-INF/seam-deployment.properties", "META-INF/seam-scanner.properties"};

    protected List<String> getPropertyValues(String key) {
        ArrayList<String> values = new ArrayList<String>();
        this.addPropertyFromSystem(key, values);
        this.addPropertyFromResourceBundle(key, values);
        return values;
    }

    private void addPropertyFromSystem(String key, List<String> values) {
        this.addProperty(key, System.getProperty(key), values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPropertyFromResourceBundle(String key, List<String> values) {
        for (String resourceName : RESOURCE_BUNDLES) {
            try {
                Enumeration<URL> urlEnum = this.getClassLoader().getResources(resourceName);
                while (urlEnum.hasMoreElements()) {
                    URL url = urlEnum.nextElement();
                    Properties properties = new Properties();
                    InputStream propertyStream = url.openStream();
                    try {
                        properties.load(propertyStream);
                        this.addProperty(key, properties.getProperty(key), values);
                    }
                    finally {
                        if (propertyStream == null) continue;
                        propertyStream.close();
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private void addProperty(String key, String value, List<String> values) {
        if (value != null) {
            String[] properties;
            for (String property : properties = Strings.split(value, ":")) {
                values.add(property);
            }
        }
    }

    public abstract void scan();

    protected Scanner getScanner() {
        if (this.scanner == null) {
            this.initScanner();
        }
        return this.scanner;
    }

    public abstract ClassLoader getClassLoader();

    public Map<String, DeploymentHandler> getDeploymentHandlers() {
        if (this.deploymentHandlers == null) {
            this.initDeploymentHandlers();
        }
        return this.deploymentHandlers;
    }

    private void initDeploymentHandlers() {
        this.deploymentHandlers = new HashMap<String, DeploymentHandler>();
        this.addHandlers(this.getPropertyValues(this.getDeploymentHandlersKey()));
    }

    protected abstract String getDeploymentHandlersKey();

    public void handle(String name) {
        for (String key : this.getDeploymentHandlers().keySet()) {
            this.getDeploymentHandlers().get(key).handle(name, this.getClassLoader());
        }
    }

    private void initScanner() {
        List<String> scanners = this.getPropertyValues(SCANNERS_KEY);
        for (String className : scanners) {
            Scanner scanner = this.instantiateScanner(className);
            if (scanner == null) continue;
            log.debug("Using " + scanner.toString());
            this.scanner = scanner;
            return;
        }
        log.debug("Using default URLScanner");
        this.scanner = new URLScanner(this);
    }

    private Scanner instantiateScanner(String className) {
        try {
            Class<?> scannerClass = this.getClassLoader().loadClass(className);
            Constructor<?> constructor = scannerClass.getConstructor(DeploymentStrategy.class);
            return (Scanner)constructor.newInstance(this);
        }
        catch (ClassNotFoundException e) {
            log.trace("Unable to use " + className + " as scanner (class not found)", e);
        }
        catch (NoClassDefFoundError e) {
            log.trace("Unable to use " + className + " as scanner (dependency not found)", e);
        }
        catch (ClassCastException e) {
            log.trace("Unable to use " + className + " as scanner (class does not implement org.jboss.seam.deployment.Scanner)");
        }
        catch (InstantiationException e) {
            log.trace("Unable to instantiate scanner " + className, e);
        }
        catch (IllegalAccessException e) {
            log.trace("Unable to instantiate scanner " + className, e);
        }
        catch (SecurityException e) {
            log.trace(className + " must declare public " + className + "( ClassLoader classLoader, String ... resourceNames )", e);
        }
        catch (NoSuchMethodException e) {
            log.trace(className + " must declare public " + className + "( ClassLoader classLoader, String ... resourceNames )", e);
        }
        catch (IllegalArgumentException e) {
            log.trace(className + " must declare public " + className + "( ClassLoader classLoader, String ... resourceNames )", e);
        }
        catch (InvocationTargetException e) {
            log.trace(className + " must declare public " + className + "( ClassLoader classLoader, String ... resourceNames )", e);
        }
        return null;
    }

    private void addHandlers(List<String> handlers) {
        for (String handler : handlers) {
            this.addHandler(handler);
        }
    }

    private void addHandler(String className) {
        DeploymentHandler deploymentHandler = this.instantiateDeploymentHandler(className);
        if (deploymentHandler != null) {
            log.debug("Adding " + deploymentHandler + " as a deployment handler");
            this.deploymentHandlers.put(deploymentHandler.getName(), deploymentHandler);
        }
    }

    private DeploymentHandler instantiateDeploymentHandler(String className) {
        try {
            Class<?> clazz = this.getClassLoader().loadClass(className);
            return (DeploymentHandler)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.trace("Unable to use " + className + " as a deployment handler (class not found)", e);
        }
        catch (NoClassDefFoundError e) {
            log.trace("Unable to use " + className + " as a deployment handler (dependency not found)", e);
        }
        catch (InstantiationException e) {
            log.trace("Unable to instantiate deployment handler " + className, e);
        }
        catch (IllegalAccessException e) {
            log.trace("Unable to instantiate deployment handler " + className, e);
        }
        return null;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public long getTimestamp() {
        return this.getScanner().getTimestamp();
    }
}

