/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.seam.web.Rewrite;

public class IncomingPattern {
    String view;
    String pattern;
    Pattern regexp;
    List<String> regexpArgs = new ArrayList<String>();

    public IncomingPattern(String view, String pattern) {
        this.view = view;
        this.pattern = pattern;
        this.parsePattern(pattern);
    }

    public Rewrite rewrite(String path) {
        return new IncomingRewrite(path);
    }

    public void parsePattern(String value) {
        StringBuffer expr = new StringBuffer();
        expr.append("^");
        while (value.length() > 0) {
            int pos = value.indexOf(123);
            if (pos == -1) {
                expr.append(this.regexpLiteral(value));
                value = "";
                continue;
            }
            int pos2 = value.indexOf(125);
            if (pos2 == -1) {
                throw new IllegalArgumentException("invalid pattern");
            }
            expr.append(this.regexpLiteral(value.substring(0, pos)));
            String arg = value.substring(pos + 1, pos2);
            expr.append(this.regexpArg(arg));
            this.regexpArgs.add(arg);
            value = value.substring(pos2 + 1);
        }
        expr.append("$");
        this.regexp = Pattern.compile(expr.toString());
    }

    private String regexpArg(String substring) {
        return "([^/]+)";
    }

    private String regexpLiteral(String value) {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                res.append(c);
                continue;
            }
            res.append('\\').append(c);
        }
        return res.toString();
    }

    public class IncomingRewrite
    implements Rewrite {
        String incoming;
        String queryArgs;
        Boolean isMatch = null;
        private List<String> matchedArgs = new ArrayList<String>();

        public IncomingRewrite(String incoming) {
            int queryPos = incoming.indexOf(63);
            if (queryPos == -1) {
                this.incoming = incoming;
                this.queryArgs = "";
            } else {
                this.incoming = incoming.substring(0, queryPos);
                this.queryArgs = incoming.substring(queryPos + 1);
            }
            this.incoming = this.stripTrailingSlash(this.incoming);
        }

        private String stripTrailingSlash(String text) {
            if (text.endsWith("/")) {
                return this.stripTrailingSlash(text.substring(0, text.length() - 1));
            }
            return text;
        }

        public boolean isMatch() {
            if (this.isMatch == null) {
                this.isMatch = this.match();
            }
            return this.isMatch;
        }

        protected boolean match() {
            if (this.incoming == null) {
                return false;
            }
            Matcher matcher = IncomingPattern.this.regexp.matcher(this.incoming);
            if (matcher.find()) {
                for (int i = 0; i < IncomingPattern.this.regexpArgs.size(); ++i) {
                    this.matchedArgs.add(matcher.group(i + 1));
                }
                return true;
            }
            return false;
        }

        public String rewrite() {
            StringBuffer result = new StringBuffer();
            result.append(IncomingPattern.this.view);
            boolean first = true;
            if (this.queryArgs.length() > 0) {
                result.append('?').append(this.queryArgs);
                first = false;
            }
            for (int i = 0; i < IncomingPattern.this.regexpArgs.size(); ++i) {
                String key = IncomingPattern.this.regexpArgs.get(i);
                String value = this.matchedArgs.get(i);
                if (first) {
                    result.append('?');
                    first = false;
                } else {
                    result.append('&');
                }
                result.append(key).append('=').append(value);
            }
            return result.toString();
        }
    }
}

