/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import org.jboss.seam.Entity;
import org.jboss.seam.contexts.Contexts;

public class Model {
    private Class<?> beanClass;

    public Model(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public final Class<?> getBeanClass() {
        return this.beanClass;
    }

    public static Model forClass(Class clazz) {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No application context active");
        }
        String name = Model.getModelName(clazz);
        Model model = (Model)Contexts.getApplicationContext().get(name);
        if (model == null) {
            model = clazz.isAnnotationPresent(javax.persistence.Entity.class) ? new Entity(clazz) : new Model(clazz);
            Contexts.getApplicationContext().set(name, model);
        }
        return model;
    }

    static String getModelName(Class clazz) {
        return clazz.getName() + ".model";
    }
}

