/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.annotations;

public enum TransactionPropagationType {
    REQUIRED,
    MANDATORY,
    SUPPORTS,
    NEVER;


    public boolean isNewTransactionRequired(boolean transactionActive) {
        switch (this) {
            case REQUIRED: {
                return !transactionActive;
            }
            case SUPPORTS: {
                return false;
            }
            case MANDATORY: {
                if (!transactionActive) {
                    throw new IllegalStateException("No transaction active on call to MANDATORY method");
                }
                return false;
            }
            case NEVER: {
                if (transactionActive) {
                    throw new IllegalStateException("Transaction active on call to NEVER method");
                }
                return false;
            }
        }
        throw new IllegalArgumentException();
    }
}

