/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.framework;

import java.io.Serializable;
import org.hibernate.Session;
import org.hibernate.TransientObjectException;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.framework.Home;

public class HibernateEntityHome<E>
extends Home<Session, E> {
    private static final long serialVersionUID = 6071072408602519385L;

    @Override
    public void create() {
        super.create();
        if (this.getSession() == null) {
            throw new IllegalStateException("hibernateSession is null");
        }
    }

    @Transactional
    public boolean isManaged() {
        return this.getInstance() != null && this.getSession().contains(this.getInstance());
    }

    @Transactional
    public String update() {
        this.getSession().flush();
        this.updatedMessage();
        this.raiseAfterTransactionSuccessEvent();
        return "updated";
    }

    @Transactional
    public String persist() {
        this.getSession().persist(this.getInstance());
        this.getSession().flush();
        this.assignId(this.getSession().getIdentifier(this.getInstance()));
        this.createdMessage();
        this.raiseAfterTransactionSuccessEvent();
        return "persisted";
    }

    @Transactional
    public String remove() {
        this.getSession().delete(this.getInstance());
        this.getSession().flush();
        this.deletedMessage();
        this.raiseAfterTransactionSuccessEvent();
        return "removed";
    }

    @Override
    @Transactional
    public E find() {
        if (this.getSession().isOpen()) {
            E result = this.loadInstance();
            if (result == null) {
                result = this.handleNotFound();
            }
            return result;
        }
        return null;
    }

    protected E loadInstance() {
        return (E)this.getSession().get(this.getEntityClass(), (Serializable)this.getId());
    }

    @Override
    protected void joinTransaction() {
        this.getSession().isOpen();
    }

    public Session getSession() {
        return (Session)this.getPersistenceContext();
    }

    public void setSession(Session session) {
        this.setPersistenceContext(session);
    }

    @Override
    protected String getPersistenceContextName() {
        return "hibernateSession";
    }

    @Override
    protected String getEntityName() {
        try {
            return this.getSession().getEntityName(this.getInstance());
        }
        catch (TransientObjectException e) {
            return this.getSession().getSessionFactory().getClassMetadata(this.getInstance().getClass()).getEntityName();
        }
    }
}

