/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Manager;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.servlet.ServletRequestSessionMap;
import org.jboss.seam.web.ServletContexts;

public abstract class ContextualHttpServletRequest {
    private static final LogProvider log = Logging.getLogProvider(ContextualHttpServletRequest.class);
    private final HttpServletRequest request;
    private static ThreadLocal<AtomicInteger> count = new ThreadLocal();

    public ContextualHttpServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public abstract void process() throws Exception;

    public void run() throws ServletException, IOException {
        log.debug("beginning request");
        if (this.request.getSession(false) == null) {
            this.request.getSession(true);
        }
        if (this.getCounterValue() == 0) {
            ServletLifecycle.beginRequest(this.request);
            ServletContexts.instance().setRequest(this.request);
            this.restoreConversationId();
            Manager.instance().restoreConversation();
            ServletLifecycle.resumeConversation(this.request);
            this.handleConversationPropagation();
        }
        try {
            this.incrementCounterValue();
            this.process();
            this.decrementCounterValue();
            if (this.getCounterValue() == 0) {
                Manager.instance().endRequest(new ServletRequestSessionMap(this.request));
                ServletLifecycle.endRequest(this.request);
            }
        }
        catch (IOException ioe) {
            this.removeCounter();
            Lifecycle.endRequest();
            log.debug("ended request due to exception");
            throw ioe;
        }
        catch (ServletException se) {
            this.removeCounter();
            Lifecycle.endRequest();
            log.debug("ended request due to exception");
            throw se;
        }
        catch (Exception e) {
            this.removeCounter();
            Lifecycle.endRequest();
            log.debug("ended request due to exception");
            throw new ServletException((Throwable)e);
        }
        finally {
            log.debug("ended request");
        }
    }

    protected void handleConversationPropagation() {
        Manager.instance().handleConversationPropagation(this.request.getParameterMap());
    }

    protected void restoreConversationId() {
        ConversationPropagation.instance().restoreConversationId(this.request.getParameterMap());
    }

    private int getCounterValue() {
        AtomicInteger i = count.get();
        if (i == null || i.intValue() < 0) {
            log.trace("Getting 0");
            return 0;
        }
        log.trace("Getting " + i.intValue());
        return i.intValue();
    }

    private void incrementCounterValue() {
        AtomicInteger i = count.get();
        if (i == null || i.intValue() < 0) {
            i = new AtomicInteger(0);
            count.set(i);
        }
        i.incrementAndGet();
        log.trace("Incrementing to " + count.get());
    }

    private void decrementCounterValue() {
        AtomicInteger i = count.get();
        if (i == null) {
            log.trace("OOps, something removed counter befor end of request!");
            throw new IllegalStateException("Counter for nested ContextualHttpServletRequest was removed before it should be!");
        }
        if (i.intValue() > 0) {
            i.decrementAndGet();
            log.trace("Decrementing to " + count.get());
        }
    }

    private void removeCounter() {
        log.trace("Removing ThreadLocal counter");
        count.remove();
    }
}

