/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import java.beans.Introspector;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jboss.seam.util.Reflections;

public class AnnotatedBeanProperty<T extends Annotation>
implements Serializable {
    private static final long serialVersionUID = 2508430507136805635L;
    private transient Field propertyField;
    private transient Method propertyGetter;
    private transient Method propertySetter;
    private String name;
    private Type propertyType;
    private T annotation;
    private boolean isFieldProperty;
    private boolean set = false;
    private Class<?> cls;
    private Class<? extends Annotation> annotationClass;

    public AnnotatedBeanProperty(Class<?> cls, Class<? extends Annotation> annotationClass) {
        this.cls = cls;
        this.annotationClass = annotationClass;
        this.init();
    }

    private void init() {
        for (Field field : this.cls.getDeclaredFields()) {
            if (!field.isAnnotationPresent(this.annotationClass)) continue;
            this.setupFieldProperty(field);
            this.annotation = field.getAnnotation(this.annotationClass);
            this.set = true;
            return;
        }
        for (Field field : this.cls.getFields()) {
            if (!field.isAnnotationPresent(this.annotationClass)) continue;
            this.annotation = field.getAnnotation(this.annotationClass);
            this.setupFieldProperty(field);
            this.set = true;
            return;
        }
        for (AccessibleObject accessibleObject : this.cls.getMethods()) {
            if (!accessibleObject.isAnnotationPresent(this.annotationClass)) continue;
            this.annotation = ((Method)accessibleObject).getAnnotation(this.annotationClass);
            String methodName = ((Method)accessibleObject).getName();
            if (((Method)accessibleObject).getName().startsWith("get")) {
                this.name = Introspector.decapitalize(((Method)accessibleObject).getName().substring(3));
            } else if (methodName.startsWith("is")) {
                this.name = Introspector.decapitalize(((Method)accessibleObject).getName().substring(2));
            }
            if (this.name != null) {
                this.propertyGetter = Reflections.getGetterMethod(this.cls, this.name);
                this.propertySetter = Reflections.getSetterMethod(this.cls, this.name);
                this.propertyType = this.propertyGetter.getGenericReturnType();
                this.isFieldProperty = false;
                this.set = true;
                continue;
            }
            throw new IllegalStateException("Invalid accessor method, must start with 'get' or 'is'.  Method: " + accessibleObject + " in class: " + this.cls);
        }
    }

    public Field getPropertyField() {
        if (this.propertyField == null) {
            this.init();
        }
        return this.propertyField;
    }

    public Method getPropertyGetter() {
        if (this.propertyGetter == null) {
            this.init();
        }
        return this.propertyGetter;
    }

    public Method getPropertySetter() {
        if (this.propertySetter == null) {
            this.init();
        }
        return this.propertySetter;
    }

    private void setupFieldProperty(Field propertyField) {
        this.propertyField = propertyField;
        this.isFieldProperty = true;
        this.name = propertyField.getName();
        this.propertyType = propertyField.getGenericType();
    }

    public void setValue(Object bean, Object value) {
        if (this.isFieldProperty) {
            Reflections.setAndWrap(this.getPropertyField(), bean, value);
        } else {
            Reflections.invokeAndWrap(this.getPropertySetter(), bean, value);
        }
    }

    public Object getValue(Object bean) {
        if (this.isFieldProperty) {
            return Reflections.getAndWrap(this.getPropertyField(), bean);
        }
        return Reflections.invokeAndWrap(this.getPropertyGetter(), bean, new Object[0]);
    }

    public String getName() {
        return this.name;
    }

    public T getAnnotation() {
        return this.annotation;
    }

    public Type getPropertyType() {
        return this.propertyType;
    }

    public boolean isSet() {
        return this.set;
    }
}

