/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Qualifier;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import org.jboss.logging.Logger;
import org.jboss.seam.persistence.util.EnvironmentUtils;
import org.jboss.seam.solder.literal.AnyLiteral;
import org.jboss.seam.solder.literal.DefaultLiteral;

public class SePersistenceContextExtension
implements Extension {
    private static final Logger log = Logger.getLogger(SePersistenceContextExtension.class);
    private Map<String, Bean<EntityManagerFactory>> emfBeans = new HashMap<String, Bean<EntityManagerFactory>>();
    private Boolean bootstrapRequired;

    void processProducer(@Observes ProcessProducer<?, EntityManager> pp, final BeanManager bm) {
        if (Boolean.FALSE.equals(this.bootstrapRequired)) {
            return;
        }
        if (this.bootstrapRequired == null) {
            if (EnvironmentUtils.isEEEnvironment()) {
                this.bootstrapRequired = false;
                return;
            }
            this.bootstrapRequired = true;
            log.info((Object)"Java SE persistence bootstrap required");
        }
        if (pp.getAnnotatedMember().isAnnotationPresent(PersistenceContext.class)) {
            HashSet<Annotation> qualifiers;
            Class<?> module;
            AnnotatedField field = (AnnotatedField)pp.getAnnotatedMember();
            final String unitName = ((PersistenceContext)field.getAnnotation(PersistenceContext.class)).unitName();
            if (!this.emfBeans.containsKey(unitName)) {
                log.info((Object)("Found persistence context producer for persistence unit: " + unitName));
                module = field.getJavaMember().getDeclaringClass();
                qualifiers = new HashSet<Annotation>();
                for (Annotation ann : field.getAnnotations()) {
                    Class<? extends Annotation> annotationType = ann.annotationType();
                    if (!annotationType.isAnnotationPresent(Qualifier.class)) continue;
                    qualifiers.add(ann);
                }
                if (qualifiers.isEmpty()) {
                    qualifiers.add((Annotation)DefaultLiteral.INSTANCE);
                }
            } else {
                throw new RuntimeException("There can only be one producer per persistence unit");
            }
            qualifiers.add((Annotation)AnyLiteral.INSTANCE);
            final boolean alternative = field.isAnnotationPresent(Alternative.class);
            final HashSet<Type> types = new HashSet<Type>(){
                private static final long serialVersionUID = 1L;
                {
                    this.add(EntityManagerFactory.class);
                    this.add(Object.class);
                }
            };
            this.emfBeans.put(unitName, new Bean<EntityManagerFactory>(){

                public Set<Type> getTypes() {
                    return types;
                }

                public Class<? extends Annotation> getScope() {
                    return ApplicationScoped.class;
                }

                public EntityManagerFactory create(CreationalContext<EntityManagerFactory> ctx) {
                    return Persistence.createEntityManagerFactory((String)unitName);
                }

                public void destroy(EntityManagerFactory emf, CreationalContext<EntityManagerFactory> ctx) {
                    emf.close();
                    ctx.release();
                }

                public Class<?> getBeanClass() {
                    return module;
                }

                public Set<InjectionPoint> getInjectionPoints() {
                    return Collections.emptySet();
                }

                public String getName() {
                    return null;
                }

                public Set<Annotation> getQualifiers() {
                    return qualifiers;
                }

                public Set<Class<? extends Annotation>> getStereotypes() {
                    return Collections.emptySet();
                }

                public boolean isAlternative() {
                    return alternative;
                }

                public boolean isNullable() {
                    return false;
                }
            });
            Producer<EntityManager> producer = new Producer<EntityManager>(){

                public Set<InjectionPoint> getInjectionPoints() {
                    return Collections.emptySet();
                }

                public EntityManager produce(CreationalContext<EntityManager> ctx) {
                    return this.getFactory(ctx).createEntityManager();
                }

                private EntityManagerFactory getFactory(CreationalContext<EntityManager> ctx) {
                    return (EntityManagerFactory)bm.getReference((Bean)SePersistenceContextExtension.this.emfBeans.get(unitName), EntityManagerFactory.class, ctx);
                }

                public void dispose(EntityManager em) {
                    if (em.isOpen()) {
                        em.close();
                    }
                }
            };
            pp.setProducer((Producer)producer);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd) {
        for (Bean<EntityManagerFactory> emfBean : this.emfBeans.values()) {
            abd.addBean(emfBean);
        }
    }
}

