/*
 * Copyright (c) 2000, 2003, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders;

import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
import org.jboss.com.sun.corba.se.spi.ior.IOR;
import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
import org.jboss.com.sun.corba.se.spi.orb.ORB;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;

/**
 * This implements the GIOP 1.0 LocateReply header.
 * 
 * @author Ram Jeyaraman 05/14/2000
 */

public final class LocateReplyMessage_1_0 extends Message_1_0 implements LocateReplyMessage
{

    // Instance variables

    private int request_id = 0;

    private int locate_status = 0;

    private IOR ior = null;

    // Constructors

    LocateReplyMessage_1_0(ORB orb)
    {
    }

    LocateReplyMessage_1_0(ORB orb, int _request_id, int _locate_status, IOR _ior)
    {
        super(Message.GIOPBigMagic, false, Message.GIOPLocateReply, 0);
        request_id = _request_id;
        locate_status = _locate_status;
        ior = _ior;
    }

    // Accessor methods

    public int getRequestId()
    {
        return this.request_id;
    }

    public int getReplyStatus()
    {
        return this.locate_status;
    }

    public short getAddrDisposition()
    {
        return KeyAddr.value;
    }

    public SystemException getSystemException(String message)
    {
        return null; // 1.0 LocateReply body does not contain SystemException
    }

    public IOR getIOR()
    {
        return this.ior;
    }

    // IO methods

    public void read(org.omg.CORBA.portable.InputStream istream)
    {
        super.read(istream);
        this.request_id = istream.read_ulong();
        this.locate_status = istream.read_long();
        isValidReplyStatus(this.locate_status); // raises exception on error

        // The code below reads the reply body if status is OBJECT_FORWARD
        if (this.locate_status == OBJECT_FORWARD)
        {
            CDRInputStream cdr = (CDRInputStream) istream;
            this.ior = IORFactories.makeIOR(cdr);
        }
    }

    // Note, this writes only the header information. IOR may be written afterwards into the reply mesg body.
    public void write(org.omg.CORBA.portable.OutputStream ostream)
    {
        super.write(ostream);
        ostream.write_ulong(this.request_id);
        ostream.write_long(this.locate_status);
    }

    // Static methods

    public static void isValidReplyStatus(int replyStatus)
    {
        switch (replyStatus)
        {
            case UNKNOWN_OBJECT :
            case OBJECT_HERE :
            case OBJECT_FORWARD :
                break;
            default :
                ORBUtilSystemException localWrapper = ORBUtilSystemException.get(CORBALogDomains.RPC_PROTOCOL);
                throw localWrapper.illegalReplyStatus(CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void callback(MessageHandler handler) throws java.io.IOException
    {
        handler.handleInput(this);
    }
} // class LocateReplyMessage_1_0
