/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.Container;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.unbound.UnboundLiteral;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.EventMessage;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

public class DeferredEventNotification<T>
implements Runnable {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.EVENT);
    private static final XLogger xLog = LoggerFactory.loggerFactory().getXLogger(Category.EVENT);
    protected final ObserverMethod<? super T> observer;
    protected final T event;

    public DeferredEventNotification(T event, ObserverMethod<? super T> observer) {
        this.observer = observer;
        this.event = event;
    }

    @Override
    public void run() {
        try {
            log.debug(EventMessage.ASYNC_FIRE, this.event, this.observer);
            new RunInRequest(){

                @Override
                protected void execute() {
                    DeferredEventNotification.this.observer.notify(DeferredEventNotification.this.event);
                }
            }.run();
        }
        catch (Exception e) {
            log.error(EventMessage.ASYNC_OBSERVER_FAILURE, this.event);
            xLog.throwing(XLogger.Level.DEBUG, e);
        }
    }

    public String toString() {
        return "Deferred event [" + this.event + "] for [" + this.observer + "]";
    }

    private static abstract class RunInRequest {
        private RunInRequest() {
        }

        protected abstract void execute();

        public void run() {
            if (this.isRequestContextActive()) {
                this.execute();
            } else {
                RequestContext requestContext = (RequestContext)Container.instance().deploymentManager().instance().select(RequestContext.class, UnboundLiteral.INSTANCE).get();
                try {
                    requestContext.activate();
                    this.execute();
                }
                finally {
                    requestContext.invalidate();
                    requestContext.deactivate();
                }
            }
        }

        private boolean isRequestContextActive() {
            for (RequestContext requestContext : Container.instance().deploymentManager().instance().select(RequestContext.class, new Annotation[0])) {
                if (!requestContext.isActive()) continue;
                return true;
            }
            return false;
        }
    }
}

