/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import javax.net.ssl.SSLContext;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.UpfrontConduitSelector;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;

public class ClientConfigConduitSelector
extends UpfrontConduitSelector {
    public Conduit selectConduit(Message message) {
        Conduit c = super.selectConduit(message);
        if (c instanceof HTTPConduit) {
            this.setAuthorizationPolicyCredentials(message, (HTTPConduit)c);
            if (((HTTPConduit)c).getTlsClientParameters() == null || ((HTTPConduit)c).getTlsClientParameters().getSslContext() == null) {
                TLSClientParameters params = ((HTTPConduit)c).getTlsClientParameters() == null ? new TLSClientParameters() : ((HTTPConduit)c).getTlsClientParameters();
                params.setSslContext((SSLContext)message.getContextualProperty("clientSSLContext"));
                params.setUseHttpsURLConnectionDefaultSslSocketFactory(false);
                ((HTTPConduit)c).setTlsClientParameters(params);
            }
        }
        return c;
    }

    private void setAuthorizationPolicyCredentials(Message message, HTTPConduit c) {
        if (message.getContextualProperty("clientUsername") != null && (message.getContextualProperty("clientHttpMechanism") == null && message.getContextualProperty("clientWSSecurityType") == null || message.getContextualProperty("clientHttpMechanism") != null && message.getContextualProperty("clientHttpMechanism").toString().equalsIgnoreCase("basic"))) {
            String defaultUsername = (String)message.get((Object)"jakarta.xml.ws.security.auth.username");
            String defaultPassword = (String)message.get((Object)"jakarta.xml.ws.security.auth.password");
            AuthorizationPolicy authorizationPolicy = new AuthorizationPolicy();
            authorizationPolicy.setUserName(defaultUsername == null ? message.getContextualProperty("clientUsername").toString() : defaultUsername);
            authorizationPolicy.setPassword(defaultPassword == null ? message.getContextualProperty("clientPassword").toString() : defaultPassword);
            c.setAuthorization(authorizationPolicy);
        }
    }
}

