/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.wsf.stack.cxf.client.configuration.MapToBeanConverter;
import org.jboss.wsf.stack.cxf.i18n.Loggers;

public final class PropertyReferenceUtils {
    public static void createPropertyReference(Map<String, String> props, Map<String, Object> target) {
        List<String> propRefKeys = props.keySet().stream().filter(k -> {
            if (k.startsWith("cxf.interceptors") || k.equalsIgnoreCase("cxf.features")) {
                return false;
            }
            return props.get(k) != null && ((String)props.get(k)).startsWith("##");
        }).collect(Collectors.toList());
        if (!propRefKeys.isEmpty()) {
            MapToBeanConverter converter = new MapToBeanConverter(props);
            propRefKeys.forEach(key -> {
                try {
                    target.put((String)key, converter.get((String)props.get(key)));
                }
                catch (Exception e) {
                    Loggers.DEPLOYMENT_LOGGER.unableToCreateConfigRef((String)key, e);
                }
            });
        }
    }
}

