/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.security.authentication;

import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;
import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;
import org.jboss.wsf.stack.cxf.security.authentication.AuthenticationManagerLoader;

public class SubjectCreatingInterceptor
extends AbstractUsernameTokenAuthenticatingInterceptor {
    private static final Logger log = Logger.getLogger(SubjectCreatingInterceptor.class);
    private SecurityAdaptorFactory secAdaptorFactory;

    public SubjectCreatingInterceptor() {
        this(Collections.emptyMap());
    }

    public SubjectCreatingInterceptor(Map<String, Object> properties) {
        super(properties);
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.secAdaptorFactory = (SecurityAdaptorFactory)spiProvider.getSPI(SecurityAdaptorFactory.class);
    }

    public Subject createSubject(String name, String password, boolean isDigest, String nonce, String created) {
        AuthenticationManagerLoader aml = null;
        try {
            aml = (AuthenticationManagerLoader)AuthenticationManagerLoader.class.newInstance();
        }
        catch (Exception ex) {
            String msg = "AuthenticationManager can not be loaded";
            log.error((Object)msg);
            throw new SecurityException(msg);
        }
        AuthenticationManager am = aml.getManager();
        if (isDigest) {
            // empty if block
        }
        SimplePrincipal principal = new SimplePrincipal(name);
        Subject subject = new Subject();
        boolean TRACE = log.isTraceEnabled();
        if (TRACE) {
            log.trace((Object)("About to authenticate, using security domain '" + am.getSecurityDomain() + "'"));
        }
        if (!am.isValid((Principal)principal, (Object)password, subject)) {
            String msg = "Authentication failed, principal=" + principal.getName();
            log.error((Object)msg);
            throw new SecurityException(msg);
        }
        SecurityAdaptor adaptor = this.secAdaptorFactory.newSecurityAdapter();
        adaptor.setPrincipal((Principal)principal);
        adaptor.setCredential((Object)password);
        adaptor.pushSubjectContext(subject, (Principal)principal, (Object)password);
        if (TRACE) {
            log.trace((Object)("Authenticated, principal=" + name));
        }
        return subject;
    }
}

