/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jboss.xnio.channels.Channels;
import org.jboss.xnio.channels.StreamSinkChannel;

public class ChannelOutputStream
extends OutputStream {
    protected volatile boolean closed;
    protected final StreamSinkChannel channel;

    public ChannelOutputStream(StreamSinkChannel channel) {
        this.channel = channel;
    }

    private static IOException closed() {
        return new IOException("The output stream is closed");
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw ChannelOutputStream.closed();
        }
        ByteBuffer buffer = ByteBuffer.wrap(new byte[]{(byte)b});
        while (this.channel.write(buffer) == 0) {
            this.channel.awaitWritable();
            if (!this.closed) continue;
            throw ChannelOutputStream.closed();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.closed) {
            throw ChannelOutputStream.closed();
        }
        ByteBuffer buffer = ByteBuffer.wrap(b);
        while (buffer.hasRemaining()) {
            while (this.channel.write(buffer) == 0) {
                try {
                    this.channel.awaitWritable();
                }
                catch (InterruptedIOException e) {
                    e.bytesTransferred = buffer.position();
                    throw e;
                }
                if (!this.closed) continue;
                throw ChannelOutputStream.closed();
            }
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw ChannelOutputStream.closed();
        }
        ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
        while (buffer.hasRemaining()) {
            while (this.channel.write(buffer) == 0) {
                try {
                    this.channel.awaitWritable();
                }
                catch (InterruptedIOException e) {
                    e.bytesTransferred = buffer.position();
                    throw e;
                }
                if (!this.closed) continue;
                throw ChannelOutputStream.closed();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        Channels.flushBlocking(this.channel);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        Channels.shutdownWritesBlocking(this.channel);
    }
}

