/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.context.exclusive.ExclusiveGroupInstance;
import org.jbpm.process.instance.impl.ConstraintEvaluator;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.internal.runtime.KnowledgeRuntime;

public class SplitInstance
extends NodeInstanceImpl {
    private static final long serialVersionUID = 510L;

    protected Split getSplit() {
        return (Split)this.getNode();
    }

    @Override
    public void internalTrigger(org.kie.api.runtime.process.NodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A Split only accepts default incoming connections!");
        }
        Split split = this.getSplit();
        try {
            this.executeStrategy(split, type);
        }
        catch (WorkflowRuntimeException wre) {
            throw wre;
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException(this, this.getProcessInstance(), "Unable to execute Split: " + e.getMessage(), e);
        }
    }

    protected void executeStrategy(Split split, String type) {
        switch (split.getType()) {
            case 1: {
                this.triggerCompleted("DROOLS_DEFAULT", true);
                break;
            }
            case 2: {
                List<Connection> outgoing = split.getDefaultOutgoingConnections();
                int priority = Integer.MAX_VALUE;
                Connection selected = null;
                for (Connection connection : outgoing) {
                    ConstraintEvaluator constraint = (ConstraintEvaluator)split.getConstraint(connection);
                    if (constraint == null || constraint.getPriority() >= priority || constraint.isDefault()) continue;
                    try {
                        if (!constraint.evaluate(this, connection, constraint)) continue;
                        selected = connection;
                        priority = constraint.getPriority();
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException("Exception when trying to evaluate constraint " + constraint.getName() + " in split " + split.getName(), e);
                    }
                }
                ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
                if (selected == null) {
                    for (Connection connection : outgoing) {
                        if (!split.isDefault(connection)) continue;
                        selected = connection;
                        break;
                    }
                }
                if (selected == null) {
                    throw new IllegalArgumentException("XOR split could not find at least one valid outgoing connection for split " + this.getSplit().getName());
                }
                if (!this.hasLoop(selected.getTo(), split)) {
                    this.setLevel(1);
                    ((NodeInstanceContainer)this.getNodeInstanceContainer()).setCurrentLevel(1);
                }
                this.triggerConnection(selected);
                break;
            }
            case 3: {
                ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
                List<Connection> outgoing = split.getDefaultOutgoingConnections();
                boolean found = false;
                ArrayList<NodeInstanceImpl.NodeInstanceTrigger> nodeInstances = new ArrayList<NodeInstanceImpl.NodeInstanceTrigger>();
                ArrayList<Connection> outgoingCopy = new ArrayList<Connection>(outgoing);
                while (!outgoingCopy.isEmpty()) {
                    int priority = Integer.MAX_VALUE;
                    Connection selectedConnection = null;
                    ConstraintEvaluator selectedConstraint = null;
                    for (Connection connection : outgoingCopy) {
                        ConstraintEvaluator constraint = (ConstraintEvaluator)split.getConstraint(connection);
                        if (constraint == null || constraint.getPriority() >= priority || constraint.isDefault()) continue;
                        priority = constraint.getPriority();
                        selectedConnection = connection;
                        selectedConstraint = constraint;
                    }
                    if (selectedConstraint == null) break;
                    if (selectedConstraint.evaluate(this, selectedConnection, selectedConstraint)) {
                        nodeInstances.add(new NodeInstanceImpl.NodeInstanceTrigger(this.followConnection(selectedConnection), selectedConnection.getToType()));
                        found = true;
                    }
                    outgoingCopy.remove(selectedConnection);
                }
                for (NodeInstanceImpl.NodeInstanceTrigger nodeInstance : nodeInstances) {
                    if (this.getProcessInstance().getState() != 1) {
                        return;
                    }
                    this.triggerNodeInstance(nodeInstance.getNodeInstance(), nodeInstance.getToType());
                }
                if (!found) {
                    for (Connection connection : outgoing) {
                        ConstraintEvaluator constraint = (ConstraintEvaluator)split.getConstraint(connection);
                        if ((constraint == null || !constraint.isDefault()) && !split.isDefault(connection)) continue;
                        this.triggerConnection(connection);
                        found = true;
                        break;
                    }
                }
                if (found) break;
                throw new IllegalArgumentException("OR split could not find at least one valid outgoing connection for split " + this.getSplit().getName());
            }
            case 4: {
                ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
                Node node = this.getNode();
                List connections = null;
                if (node != null) {
                    connections = node.getOutgoingConnections(type);
                }
                if (connections == null || connections.isEmpty()) {
                    ((NodeInstanceContainer)this.getNodeInstanceContainer()).nodeInstanceCompleted(this, type);
                    break;
                }
                ExclusiveGroupInstance groupInstance = new ExclusiveGroupInstance();
                org.kie.api.runtime.process.NodeInstanceContainer parent = this.getNodeInstanceContainer();
                if (!(parent instanceof ContextInstanceContainer)) {
                    throw new IllegalArgumentException("An Exclusive AND is only possible if the parent is a context instance container");
                }
                ((ContextInstanceContainer)parent).addContextInstance("ExclusiveGroup", groupInstance);
                HashMap<NodeInstance, String> nodeInstancesMap = new HashMap<NodeInstance, String>();
                for (Connection connection : connections) {
                    nodeInstancesMap.put(this.followConnection(connection), connection.getToType());
                }
                for (NodeInstance nodeInstance : nodeInstancesMap.keySet()) {
                    groupInstance.addNodeInstance(nodeInstance);
                }
                for (Map.Entry entry : nodeInstancesMap.entrySet()) {
                    if (this.getProcessInstance().getState() != 1) {
                        return;
                    }
                    boolean hidden = false;
                    if (this.getNode().getMetaData().get("hidden") != null) {
                        hidden = true;
                    }
                    InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
                    if (!hidden) {
                        ((InternalProcessRuntime)kruntime.getProcessRuntime()).getProcessEventSupport().fireBeforeNodeLeft((org.kie.api.runtime.process.NodeInstance)this, (KnowledgeRuntime)kruntime);
                    }
                    ((NodeInstance)entry.getKey()).trigger(this, (String)entry.getValue());
                    if (hidden) continue;
                    ((InternalProcessRuntime)kruntime.getProcessRuntime()).getProcessEventSupport().fireAfterNodeLeft((org.kie.api.runtime.process.NodeInstance)this, (KnowledgeRuntime)kruntime);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal split type " + split.getType());
            }
        }
    }

    protected boolean hasLoop(Node startAt, Node lookFor) {
        HashSet<Long> vistedNodes = new HashSet<Long>();
        return this.checkNodes(startAt, lookFor, vistedNodes);
    }

    protected boolean checkNodes(Node currentNode, Node lookFor, Set<Long> vistedNodes) {
        List connections = currentNode.getOutgoingConnections("DROOLS_DEFAULT");
        for (Connection conn : connections) {
            Node nextNode = conn.getTo();
            if (nextNode == null || vistedNodes.contains(nextNode.getId())) continue;
            vistedNodes.add(nextNode.getId());
            if (nextNode.getId() == lookFor.getId()) {
                return true;
            }
            boolean nestedCheck = this.checkNodes(nextNode, lookFor, vistedNodes);
            if (!nestedCheck) continue;
            return true;
        }
        return false;
    }
}

