/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.kie.internal.process.CorrelationKey;

public class DefaultProcessInstanceManager
implements ProcessInstanceManager {
    private Map<Long, org.kie.api.runtime.process.ProcessInstance> processInstances = new ConcurrentHashMap<Long, org.kie.api.runtime.process.ProcessInstance>();
    private Map<CorrelationKey, org.kie.api.runtime.process.ProcessInstance> processInstancesByCorrelationKey = new ConcurrentHashMap<CorrelationKey, org.kie.api.runtime.process.ProcessInstance>();
    private AtomicLong processCounter = new AtomicLong(0L);

    @Override
    public void addProcessInstance(org.kie.api.runtime.process.ProcessInstance processInstance, CorrelationKey correlationKey) {
        ((ProcessInstance)processInstance).setId(this.processCounter.incrementAndGet());
        this.internalAddProcessInstance(processInstance);
        if (correlationKey != null) {
            if (this.processInstancesByCorrelationKey.containsKey(correlationKey)) {
                throw new RuntimeException(correlationKey + " already exists");
            }
            this.processInstancesByCorrelationKey.put(correlationKey, processInstance);
        }
    }

    @Override
    public void internalAddProcessInstance(org.kie.api.runtime.process.ProcessInstance processInstance) {
        this.processInstances.put(processInstance.getId(), processInstance);
    }

    @Override
    public Collection<org.kie.api.runtime.process.ProcessInstance> getProcessInstances() {
        return Collections.unmodifiableCollection(this.processInstances.values());
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(long id) {
        return this.processInstances.get(id);
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(long id, boolean readOnly) {
        return this.processInstances.get(id);
    }

    @Override
    public void removeProcessInstance(org.kie.api.runtime.process.ProcessInstance processInstance) {
        this.internalRemoveProcessInstance(processInstance);
    }

    @Override
    public void internalRemoveProcessInstance(org.kie.api.runtime.process.ProcessInstance processInstance) {
        this.processInstances.remove(processInstance.getId());
        for (Map.Entry<CorrelationKey, org.kie.api.runtime.process.ProcessInstance> entry : this.processInstancesByCorrelationKey.entrySet()) {
            if (entry.getValue().getId() != processInstance.getId()) continue;
            this.processInstancesByCorrelationKey.remove(entry.getKey());
        }
    }

    @Override
    public void clearProcessInstances() {
        this.processInstances.clear();
    }

    @Override
    public void clearProcessInstancesState() {
    }

    @Override
    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        return this.processInstancesByCorrelationKey.get(correlationKey);
    }
}

