/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.runtime.process.NodeInstance;

public class BoundaryEventNodeInstance
extends EventNodeInstance {
    private static final long serialVersionUID = -4958054074031174180L;

    @Override
    public void signalEvent(String type, Object event) {
        BoundaryEventNode boundaryNode = this.getEventNode();
        String attachedTo = boundaryNode.getAttachedToNodeId();
        Collection nodeInstances = ((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstances();
        if (type != null && type.startsWith("Compensation")) {
            if (!this.isAttachedToNodeActive(nodeInstances, attachedTo, type, event) && this.isAttachedToNodeCompleted(attachedTo)) {
                super.signalEvent(type, event);
            } else {
                this.cancel();
            }
        } else if (this.isAttachedToNodeActive(nodeInstances, attachedTo, type, event)) {
            super.signalEvent(type, event);
        } else {
            this.cancel();
        }
    }

    @Override
    public BoundaryEventNode getEventNode() {
        return (BoundaryEventNode)super.getEventNode();
    }

    @Override
    public void triggerCompleted(String type, Object event) {
        Collection nodeInstances = ((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstances();
        String attachedTo = this.getEventNode().getAttachedToNodeId();
        NodeInstance nodeInstance = this.getAttachedToNodeActive(nodeInstances, attachedTo, type, event);
        List<DataAssociation> dataAssociation = this.getEventNode().getOutAssociations();
        if (!dataAssociation.isEmpty()) {
            HashMap<String, Object> outputData = new HashMap<String, Object>();
            outputData.put(dataAssociation.get(0).getSources().get(0), event);
            outputData.put("nodeInstance", nodeInstance);
            outputData.put("signal", type);
            outputData.put("event", event);
            if (nodeInstance instanceof WorkItemNodeInstance) {
                outputData.put("workItem", ((WorkItemNodeInstance)nodeInstance).getWorkItem());
            }
            this.mapOutputSetVariables(this, this.getEventNode().getOutAssociations(), outputData);
        }
        this.triggerEvent("onBoundary");
        super.triggerCompleted();
    }

    private boolean isAttachedToNodeActive(Collection<NodeInstance> nodeInstances, String attachedTo, String type, Object event) {
        return this.getAttachedToNodeActive(nodeInstances, attachedTo, type, event) != null;
    }

    private NodeInstance getAttachedToNodeActive(Collection<NodeInstance> nodeInstances, String attachedTo, String type, Object event) {
        if (nodeInstances != null && !nodeInstances.isEmpty()) {
            for (NodeInstance nInstance : nodeInstances) {
                NodeInstance nodeInstance;
                String nodeUniqueId = (String)nInstance.getNode().getMetaData().get("UniqueId");
                boolean isActivating = ((WorkflowProcessInstanceImpl)nInstance.getProcessInstance()).getActivatingNodeIds().contains(nodeUniqueId);
                if (attachedTo.equals(nodeUniqueId) && !isActivating) {
                    if (type.startsWith("Timer-")) {
                        if (Long.valueOf(nInstance.getId()).equals(event)) {
                            return nInstance;
                        }
                    } else {
                        return nInstance;
                    }
                }
                if (!(nInstance instanceof CompositeNodeInstance) || (nodeInstance = this.getAttachedToNodeActive(((CompositeNodeInstance)nInstance).getNodeInstances(), attachedTo, type, event)) == null) continue;
                return nodeInstance;
            }
        }
        return null;
    }

    private boolean isAttachedToNodeCompleted(String attachedTo) {
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)this.getProcessInstance();
        return processInstance.getCompletedNodeIds().contains(attachedTo);
    }

    @Override
    public void cancel(NodeInstance.CancelType cancelType) {
        this.getProcessInstance().removeEventListener(this.getEventType(), this.getEventListener(), true);
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
    }
}

