/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.ArrayList;
import java.util.List;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.event.RowSelectionHandler;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.MosaicPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.IFrameWindowPanel;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.common.WidgetWindowPanel;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.TokenReference;
import org.jboss.bpm.console.client.process.ClearInstancesAction;
import org.jboss.bpm.console.client.process.InstanceDetailView;
import org.jboss.bpm.console.client.process.SignalExecutionAction;
import org.jboss.bpm.console.client.process.UpdateInstanceDetailAction;
import org.jboss.bpm.console.client.process.events.InstanceEvent;
import org.jboss.bpm.console.client.util.SimpleDateFormat;
import org.jboss.errai.workspaces.client.api.ProvisioningCallback;
import org.jboss.errai.workspaces.client.api.WidgetProvider;
import org.jboss.errai.workspaces.client.framework.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceListView
implements WidgetProvider,
ViewInterface,
DataDriven {
    public static final String ID = InstanceListView.class.getName();
    private Controller controller;
    private MosaicPanel instanceList = null;
    private ListBox<ProcessInstanceRef> listBox;
    private ProcessDefinitionRef currentDefinition;
    private boolean isInitialized;
    private List<ProcessInstanceRef> cachedInstances = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private ApplicationContext appContext;
    private IFrameWindowPanel iframeWindow = null;
    private boolean isRiftsawInstance;
    MosaicPanel panel;
    private Button startBtn;
    private Button terminateBtn;
    private Button deleteBtn;
    private Button signalBtn;
    private List<TokenReference> tokensToSignal = null;
    private WidgetWindowPanel signalWindowPanel;
    private ListBox<TokenReference> listBoxTokens = null;
    private List<TextBox> signalTextBoxes = null;
    private ListBox<String> listBoxTokenSignals;

    public void provideWidget(ProvisioningCallback callback) {
        this.appContext = (ApplicationContext)Registry.get(ApplicationContext.class);
        this.isRiftsawInstance = this.appContext.getConfig().getProfileName().equals("BPEL Console");
        this.panel = new MosaicPanel();
        this.panel.setPadding(0);
        ((Controller)Registry.get(Controller.class)).addView(ID, (ViewInterface)this);
        this.initialize();
        callback.onSuccess((Widget)this.panel);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.instanceList = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            this.instanceList.setPadding(0);
            this.instanceList.setWidgetSpacing(0);
            this.listBox = new ListBox(new String[]{"<b>Instance</b>", "State", "Start Date"});
            this.listBox.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
            this.listBox.addRowSelectionHandler((RowSelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
            MosaicPanel toolBox = new MosaicPanel();
            toolBox.setPadding(0);
            toolBox.setWidgetSpacing(5);
            ToolBar toolBar = new ToolBar();
            this.startBtn = new Button("Start", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.terminateBtn = new Button("Terminate", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.deleteBtn = new Button("Delete", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.signalBtn = new Button("Signal", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            if (!this.isRiftsawInstance) {
                toolBar.add((Widget)this.startBtn);
                toolBar.add((Widget)this.signalBtn);
                toolBar.add((Widget)this.deleteBtn);
                this.startBtn.setEnabled(false);
                this.deleteBtn.setEnabled(false);
                this.signalBtn.setEnabled(false);
            }
            toolBar.add((Widget)this.terminateBtn);
            this.terminateBtn.setEnabled(false);
            toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.instanceList.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.instanceList.add((Widget)this.listBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            if (this.cachedInstances != null) {
                this.bindData(this.cachedInstances);
            }
            MosaicPanel layout = new MosaicPanel((LayoutManager)new BorderLayout());
            layout.setPadding(0);
            layout.add((Widget)this.instanceList, (LayoutData)new BorderLayoutData(BorderLayout.Region.CENTER));
            InstanceDetailView detailsView = new InstanceDetailView();
            this.controller.addView(InstanceDetailView.ID, (ViewInterface)detailsView);
            this.controller.addAction(UpdateInstanceDetailAction.ID, (ActionInterface)new UpdateInstanceDetailAction());
            this.controller.addAction(ClearInstancesAction.ID, (ActionInterface)new ClearInstancesAction());
            this.controller.addAction(SignalExecutionAction.ID, (ActionInterface)new SignalExecutionAction());
            layout.add((Widget)detailsView, (LayoutData)new BorderLayoutData(BorderLayout.Region.SOUTH, 10, 200));
            this.panel.add((Widget)layout);
            this.isInitialized = true;
        }
    }

    public ProcessInstanceRef getSelection() {
        ProcessInstanceRef selection = null;
        if (this.listBox.getSelectedIndex() != -1) {
            selection = (ProcessInstanceRef)this.listBox.getItem(this.listBox.getSelectedIndex());
        }
        return selection;
    }

    public ProcessDefinitionRef getCurrentDefinition() {
        return this.currentDefinition;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void reset() {
        this.currentDefinition = null;
        this.cachedInstances = new ArrayList();
        this.renderUpdate();
        this.startBtn.setEnabled(false);
        this.terminateBtn.setEnabled(false);
        this.deleteBtn.setEnabled(false);
        this.signalBtn.setEnabled(false);
    }

    public void update(Object ... data) {
        this.currentDefinition = (ProcessDefinitionRef)data[0];
        this.cachedInstances = (List)data[1];
        this.renderUpdate();
    }

    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.instanceList, (boolean)isLoading);
    }

    private void renderUpdate() {
        if (this.isInitialized()) {
            this.bindData(this.cachedInstances);
            this.controller.handleEvent(new Event(UpdateInstanceDetailAction.ID, (Object)new InstanceEvent(this.currentDefinition, null)));
            this.startBtn.setEnabled(true);
            this.terminateBtn.setEnabled(true);
            this.deleteBtn.setEnabled(true);
        }
    }

    private void bindData(List<ProcessInstanceRef> instances) {
        DefaultListModel model = (DefaultListModel)this.listBox.getModel();
        model.clear();
        List<ProcessInstanceRef> list = instances;
        for (ProcessInstanceRef inst : list) {
            model.add((Object)inst);
        }
        this.panel.invalidate();
    }

    private boolean isSignalable(ProcessInstanceRef processInstance) {
        this.tokensToSignal = new ArrayList();
        if (processInstance.getRootToken() != null && processInstance.getRootToken().canBeSignaled()) {
            this.tokensToSignal.add(processInstance.getRootToken());
        } else if (processInstance.getRootToken() != null && processInstance.getRootToken().getChildren() != null) {
            this.collectSignalableTokens(processInstance.getRootToken(), this.tokensToSignal);
        }
        return this.tokensToSignal.size() > 0;
    }

    private void collectSignalableTokens(TokenReference tokenParent, List<TokenReference> tokensToSignal) {
        if (tokenParent.getChildren() != null) {
            for (TokenReference token : tokenParent.getChildren()) {
                if (token.canBeSignaled()) {
                    tokensToSignal.add(token);
                }
                this.collectSignalableTokens(token, tokensToSignal);
            }
        }
    }

    private void createSignalWindow() {
        this.signalTextBoxes = new ArrayList();
        MosaicPanel layout = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        layout.setStyleName("bpm-window-layout");
        layout.setPadding(5);
        MosaicPanel toolBox = new MosaicPanel();
        toolBox.setPadding(0);
        toolBox.setWidgetSpacing(5);
        toolBox.setLayout((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
        ToolBar toolBar = new ToolBar();
        toolBar.add((Widget)new Button("Signal", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
        toolBar.add((Widget)new Button("Cancel", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
        Label header = new Label("Available tokens to signal: ");
        header.setStyleName("bpm-label-header");
        layout.add((Widget)header, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        layout.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.listBoxTokens = new ListBox(new String[]{"Id", "Name"});
        this.listBoxTokens.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
        this.listBoxTokens.addRowSelectionHandler((RowSelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.renderSignalListBox(-1);
        layout.add((Widget)this.listBoxTokens, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        Label headerSignals = new Label("Available signal names");
        headerSignals.setStyleName("bpm-label-header");
        layout.add((Widget)headerSignals, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.listBoxTokenSignals = new ListBox(new String[]{"Signal name"});
        this.listBoxTokenSignals.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
        layout.add((Widget)this.listBoxTokenSignals, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        this.signalWindowPanel = new WidgetWindowPanel("Signal proces from wait state", (Widget)layout, true);
    }

    public void renderSignalListBox(int i) {
        if (i > -1) {
            this.tokensToSignal.remove(i);
        }
        if (this.tokensToSignal.isEmpty()) {
            this.signalWindowPanel.close();
        }
        ((DefaultListModel)this.listBoxTokens.getModel()).clear();
        for (TokenReference token : this.tokensToSignal) {
            ((DefaultListModel)this.listBoxTokens.getModel()).add((Object)token);
        }
        if (this.listBoxTokenSignals != null) {
            ((DefaultListModel)this.listBoxTokenSignals.getModel()).clear();
        }
    }

    private void renderAvailableSignals(TokenReference item) {
        ((DefaultListModel)this.listBoxTokenSignals.getModel()).clear();
        for (String signal : item.getAvailableSignals()) {
            ((DefaultListModel)this.listBoxTokenSignals.getModel()).add((Object)signal);
        }
    }

    static /* synthetic */ SimpleDateFormat access$000(InstanceListView x0) {
        return x0.dateFormat;
    }

    static /* synthetic */ ListBox access$100(InstanceListView x0) {
        return x0.listBox;
    }

    static /* synthetic */ boolean access$200(InstanceListView x0, ProcessInstanceRef x1) {
        return x0.isSignalable(x1);
    }

    static /* synthetic */ Button access$300(InstanceListView x0) {
        return x0.signalBtn;
    }

    static /* synthetic */ ProcessDefinitionRef access$400(InstanceListView x0) {
        return x0.currentDefinition;
    }

    static /* synthetic */ Controller access$500(InstanceListView x0) {
        return x0.controller;
    }

    static /* synthetic */ IFrameWindowPanel access$602(InstanceListView x0, IFrameWindowPanel x1) {
        x0.iframeWindow = x1;
        return x0.iframeWindow;
    }

    static /* synthetic */ IFrameWindowPanel access$600(InstanceListView x0) {
        return x0.iframeWindow;
    }

    static /* synthetic */ void access$700(InstanceListView x0) {
        x0.createSignalWindow();
    }

    static /* synthetic */ ListBox access$800(InstanceListView x0) {
        return x0.listBoxTokens;
    }

    static /* synthetic */ ListBox access$900(InstanceListView x0) {
        return x0.listBoxTokenSignals;
    }

    static /* synthetic */ WidgetWindowPanel access$1000(InstanceListView x0) {
        return x0.signalWindowPanel;
    }

    static /* synthetic */ void access$1100(InstanceListView x0, TokenReference x1) {
        x0.renderAvailableSignals(x1);
    }
}

