/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jbpm.kie.services.impl.admin.TaskNotificationImpl;
import org.jbpm.services.api.admin.TaskNotification;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.runtime.Context;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskModelFactory;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.EmailNotification;
import org.kie.internal.task.api.model.EmailNotificationHeader;
import org.kie.internal.task.api.model.Escalation;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.Language;
import org.kie.internal.task.api.model.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTaskNotificationsCommand
extends UserGroupCallbackTaskCommand<List<TaskNotification>> {
    private static final long serialVersionUID = -1856489382099976731L;
    private static final Logger logger = LoggerFactory.getLogger(ListTaskNotificationsCommand.class);
    private boolean activeOnly;
    private TaskModelFactory factory = TaskModelProvider.getFactory();

    public ListTaskNotificationsCommand(String userId, long taskId, boolean activeOnly) {
        this.setUserId(userId);
        this.setTaskId(taskId);
        this.activeOnly = activeOnly;
    }

    public List<TaskNotification> execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        Language lang = this.factory.newLanguage();
        lang.setMapkey("en-UK");
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId.longValue());
        if (!this.isBusinessAdmin(this.userId, task.getPeopleAssignments().getBusinessAdministrators(), (org.kie.internal.task.api.TaskContext)context)) {
            throw new PermissionDeniedException("User " + this.userId + " is not business admin of task " + this.taskId);
        }
        Deadlines deadlines = ((InternalTask)task).getDeadlines();
        List notificationsNotStarted = deadlines.getStartDeadlines().stream().filter(d -> !d.getEscalations().isEmpty() && !((Escalation)d.getEscalations().get(0)).getNotifications().isEmpty()).map(d -> {
            Notification n = (Notification)((Escalation)d.getEscalations().get(0)).getNotifications().get(0);
            EmailNotificationHeader email = (EmailNotificationHeader)((EmailNotification)n).getEmailHeaders().get(lang);
            return new TaskNotificationImpl(d.getId(), this.get(n.getNames()), email.getSubject(), email.getBody(), d.getDate(), n.getRecipients(), n.getBusinessAdministrators(), d.isEscalated() == false);
        }).collect(Collectors.toList());
        List notificationsNotCompleted = deadlines.getEndDeadlines().stream().filter(d -> !d.getEscalations().isEmpty() && !((Escalation)d.getEscalations().get(0)).getNotifications().isEmpty()).map(d -> {
            Notification n = (Notification)((Escalation)d.getEscalations().get(0)).getNotifications().get(0);
            EmailNotificationHeader email = (EmailNotificationHeader)((EmailNotification)n).getEmailHeaders().get(lang);
            return new TaskNotificationImpl(d.getId(), this.get(n.getNames()), email.getSubject(), email.getBody(), d.getDate(), n.getRecipients(), n.getBusinessAdministrators(), d.isEscalated() == false);
        }).collect(Collectors.toList());
        List<Object> result = new ArrayList<TaskNotification>();
        result.addAll(notificationsNotStarted);
        result.addAll(notificationsNotCompleted);
        if (this.activeOnly) {
            logger.debug("Removing already completed deadlines from the result");
            result = result.stream().filter(t -> t.isActive()).collect(Collectors.toList());
        }
        return result;
    }

    protected String get(List<I18NText> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        return list.get(0).getText();
    }
}

