/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.api;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessEngine;
import org.xml.sax.InputSource;

public class Configuration {
    private static ProcessEngine singleton;
    transient Configuration impl;

    public Configuration() {
        this.impl = this.instantiate("org.jbpm.pvm.internal.cfg.ConfigurationImpl");
    }

    protected Configuration(Object o) {
    }

    protected Configuration instantiate(String className) {
        Configuration implementation;
        try {
            Class<?> implementationClass = Class.forName(className, true, this.getClassLoader());
            implementation = (Configuration)implementationClass.newInstance();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't instantiate configuration of type " + className, e);
        }
        return implementation;
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Configuration setXmlString(String xmlString) {
        this.impl.setXmlString(xmlString);
        return this.impl;
    }

    public Configuration setResource(String resource) {
        this.impl.setResource(resource);
        return this.impl;
    }

    public Configuration setInputStream(InputStream inputStream) {
        this.impl.setInputStream(inputStream);
        return this.impl;
    }

    public Configuration setInputSource(InputSource inputSource) {
        this.impl.setInputSource(inputSource);
        return this.impl;
    }

    public Configuration setUrl(URL url) {
        this.impl.setUrl(url);
        return this.impl;
    }

    public Configuration setFile(File file) {
        this.impl.setFile(file);
        return this.impl;
    }

    public ProcessEngine buildProcessEngine() {
        return this.impl.buildProcessEngine();
    }

    public Configuration setHibernateSessionFactory(Object hibernateSessionFactory) {
        return this.impl.setHibernateSessionFactory(hibernateSessionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProcessEngine getProcessEngine() {
        if (singleton != null) return singleton;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (singleton != null) return singleton;
            singleton = new Configuration().setResource("jbpm.cfg.xml").buildProcessEngine();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }
}

