/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.atmos.AtmosAsyncClient;
import org.jclouds.atmos.blobstore.functions.BlobToObject;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.options.GetOptions;
import org.jclouds.rest.internal.RestAnnotationProcessor;

@Singleton
public class AtmosBlobRequestSigner
implements BlobRequestSigner {
    private final RestAnnotationProcessor<AtmosAsyncClient> processor;
    private final BlobToObject blobToObject;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Method getMethod;
    private final Method deleteMethod;
    private final Method createMethod;

    @Inject
    public AtmosBlobRequestSigner(RestAnnotationProcessor<AtmosAsyncClient> processor, BlobToObject blobToObject, BlobToHttpGetOptions blob2ObjectGetOptions) throws SecurityException, NoSuchMethodException {
        this.processor = (RestAnnotationProcessor)Preconditions.checkNotNull(processor, (Object)"processor");
        this.blobToObject = (BlobToObject)Preconditions.checkNotNull((Object)blobToObject, (Object)"blobToObject");
        this.blob2ObjectGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2ObjectGetOptions, (Object)"blob2ObjectGetOptions");
        this.getMethod = AtmosAsyncClient.class.getMethod("readFile", String.class, GetOptions[].class);
        this.deleteMethod = AtmosAsyncClient.class.getMethod("deletePath", String.class);
        this.createMethod = AtmosAsyncClient.class.getMethod("createFile", String.class, AtmosObject.class, PutOptions[].class);
    }

    public HttpRequest signGetBlob(String container, String name) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.getMethod, new Object[]{this.getPath(container, name)}));
    }

    public HttpRequest signPutBlob(String container, Blob blob) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.createMethod, new Object[]{container, this.blobToObject.apply(blob)}));
    }

    public HttpRequest signRemoveBlob(String container, String name) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.deleteMethod, new Object[]{this.getPath(container, name)}));
    }

    private String getPath(String container, String name) {
        return (String)Preconditions.checkNotNull((Object)container, (Object)"container") + "/" + (String)Preconditions.checkNotNull((Object)name, (Object)"name");
    }

    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.getMethod, new Object[]{this.getPath(container, name), this.blob2ObjectGetOptions.apply(options)}));
    }
}

