/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.atmos.AtmosClient;
import org.jclouds.atmos.blobstore.functions.BlobStoreListOptionsToListOptions;
import org.jclouds.atmos.blobstore.functions.BlobToObject;
import org.jclouds.atmos.blobstore.functions.DirectoryEntryListToResourceMetadataList;
import org.jclouds.atmos.blobstore.functions.ObjectToBlob;
import org.jclouds.atmos.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.atmos.options.ListOptions;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.atmos.util.AtmosUtils;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.crypto.Crypto;
import org.jclouds.domain.Location;
import org.jclouds.http.options.GetOptions;

@Singleton
public class AtmosBlobStore
extends BaseBlobStore {
    private final AtmosClient sync;
    private final ObjectToBlob object2Blob;
    private final ObjectToBlobMetadata object2BlobMd;
    private final BlobToObject blob2Object;
    private final BlobStoreListOptionsToListOptions container2ContainerListOptions;
    private final DirectoryEntryListToResourceMetadataList container2ResourceList;
    private final Crypto crypto;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Provider<FetchBlobMetadata> fetchBlobMetadataProvider;
    private final Map<String, Boolean> isPublic;

    @Inject
    AtmosBlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, AtmosClient sync, ObjectToBlob object2Blob, ObjectToBlobMetadata object2BlobMd, BlobToObject blob2Object, BlobStoreListOptionsToListOptions container2ContainerListOptions, DirectoryEntryListToResourceMetadataList container2ResourceList, Crypto crypto, BlobToHttpGetOptions blob2ObjectGetOptions, Provider<FetchBlobMetadata> fetchBlobMetadataProvider, Map<String, Boolean> isPublic) {
        super(context, blobUtils, defaultLocation, locations);
        this.blob2ObjectGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2ObjectGetOptions, (Object)"blob2ObjectGetOptions");
        this.sync = (AtmosClient)Preconditions.checkNotNull((Object)sync, (Object)"sync");
        this.container2ContainerListOptions = (BlobStoreListOptionsToListOptions)Preconditions.checkNotNull((Object)container2ContainerListOptions, (Object)"container2ContainerListOptions");
        this.container2ResourceList = (DirectoryEntryListToResourceMetadataList)Preconditions.checkNotNull((Object)container2ResourceList, (Object)"container2ResourceList");
        this.object2Blob = (ObjectToBlob)Preconditions.checkNotNull((Object)object2Blob, (Object)"object2Blob");
        this.blob2Object = (BlobToObject)Preconditions.checkNotNull((Object)blob2Object, (Object)"blob2Object");
        this.object2BlobMd = (ObjectToBlobMetadata)Preconditions.checkNotNull((Object)object2BlobMd, (Object)"object2BlobMd");
        this.crypto = (Crypto)Preconditions.checkNotNull((Object)crypto, (Object)"crypto");
        this.fetchBlobMetadataProvider = (Provider)Preconditions.checkNotNull(fetchBlobMetadataProvider, (Object)"fetchBlobMetadataProvider");
        this.isPublic = (Map)Preconditions.checkNotNull(isPublic, (Object)"isPublic");
    }

    public BlobMetadata blobMetadata(String container, String key) {
        return this.object2BlobMd.apply(this.sync.headFile(container + "/" + key));
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        this.sync.deletePath(container + "/");
        return !this.sync.pathExists(container + "/");
    }

    public boolean createContainerInLocation(Location location, String container) {
        this.sync.createDirectory(container, new org.jclouds.atmos.options.PutOptions[0]);
        return true;
    }

    public void createDirectory(String container, String directory) {
        this.sync.createDirectory(container + "/" + directory, new org.jclouds.atmos.options.PutOptions[0]);
    }

    public void deleteDirectory(String containerName, String directory) {
        this.removeBlob(containerName, directory + "/");
    }

    public boolean containerExists(String container) {
        return this.sync.pathExists(container + "/");
    }

    public boolean directoryExists(String container, String directory) {
        return this.sync.pathExists(container + "/" + directory + "/");
    }

    public boolean blobExists(String container, String key) {
        return this.sync.pathExists(container + "/" + key);
    }

    public Blob getBlob(String container, String key, org.jclouds.blobstore.options.GetOptions options) {
        GetOptions httpOptions = this.blob2ObjectGetOptions.apply(options);
        return this.object2Blob.apply(this.sync.readFile(container + "/" + key, httpOptions));
    }

    public PageSet<? extends StorageMetadata> list() {
        return this.container2ResourceList.apply(this.sync.listDirectories(new ListOptions[0]));
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        container = AtmosUtils.adjustContainerIfDirOptionPresent(container, options);
        ListOptions nativeOptions = this.container2ContainerListOptions.apply(options);
        PageSet list = this.container2ResourceList.apply(this.sync.listDirectory(container, nativeOptions));
        return options.isDetailed() ? ((FetchBlobMetadata)this.fetchBlobMetadataProvider.get()).setContainerName(container).apply(list) : list;
    }

    public String putBlob(String container, Blob blob) {
        org.jclouds.atmos.options.PutOptions options = new org.jclouds.atmos.options.PutOptions();
        try {
            if (this.isPublic.get(container + "/").booleanValue()) {
                options.publicRead();
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return AtmosUtils.putBlob(this.sync, this.crypto, this.blob2Object, container, blob, options);
    }

    public String putBlob(String container, Blob blob, PutOptions options) {
        return this.putBlob(container, blob);
    }

    public void removeBlob(String container, String key) {
        this.sync.deletePath(container + "/" + key);
    }

    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        if (options.isPublicRead()) {
            this.sync.createDirectory(container, PutOptions.Builder.publicRead());
            return true;
        }
        return this.createContainerInLocation(location, container);
    }
}

