/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.config;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.jclouds.atmos.AtmosAsyncClient;
import org.jclouds.atmos.AtmosClient;
import org.jclouds.atmos.blobstore.AtmosAsyncBlobStore;
import org.jclouds.atmos.blobstore.AtmosBlobRequestSigner;
import org.jclouds.atmos.blobstore.AtmosBlobStore;
import org.jclouds.atmos.blobstore.strategy.FindMD5InUserMetadata;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.blobstore.config.BlobStoreMapModule;
import org.jclouds.blobstore.internal.BlobStoreContextImpl;
import org.jclouds.blobstore.strategy.ContainsValueInListStrategy;
import org.jclouds.location.config.JustProviderLocationModule;

public class AtmosBlobStoreContextModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new BlobStoreMapModule());
        this.bind(ConsistencyModel.class).toInstance((Object)ConsistencyModel.EVENTUAL);
        this.bind(AsyncBlobStore.class).to(AtmosAsyncBlobStore.class).in(Scopes.SINGLETON);
        this.bind(BlobStore.class).to(AtmosBlobStore.class).in(Scopes.SINGLETON);
        this.bind(BlobStoreContext.class).to((TypeLiteral)new TypeLiteral<BlobStoreContextImpl<AtmosClient, AtmosAsyncClient>>(){}).in(Scopes.SINGLETON);
        this.bind(ContainsValueInListStrategy.class).to(FindMD5InUserMetadata.class);
        this.bind(BlobRequestSigner.class).to(AtmosBlobRequestSigner.class);
        this.install((Module)new JustProviderLocationModule());
    }

    @Provides
    @Singleton
    protected Map<String, Boolean> isPublic(final AtmosClient client) {
        return new MapMaker().expireAfterWrite(30L, TimeUnit.SECONDS).makeComputingMap((Function)new Function<String, Boolean>(){

            public Boolean apply(String directory) {
                return client.isPublic(directory);
            }

            public String toString() {
                return "isPublic()";
            }
        });
    }
}

