/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.annotation.Nullable;
import org.jclouds.blobstore.KeyAlreadyExistsException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.InvocationContext;
import org.jclouds.util.Throwables2;

public class ReturnEndpointIfAlreadyExists
implements Function<Exception, URI>,
InvocationContext<ReturnEndpointIfAlreadyExists> {
    private URI endpoint;

    public URI apply(Exception from) {
        if (Preconditions.checkNotNull((Object)from, (Object)"exception") instanceof KeyAlreadyExistsException) {
            return this.endpoint;
        }
        return (URI)URI.class.cast(Throwables2.propagateOrNull((Exception)from));
    }

    public ReturnEndpointIfAlreadyExists setContext(HttpRequest request) {
        return this.setEndpoint(request == null ? null : request.getEndpoint());
    }

    @VisibleForTesting
    ReturnEndpointIfAlreadyExists setEndpoint(@Nullable URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }
}

