/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.Uris;
import org.jclouds.openstack.swift.domain.ObjectInfo;

@Singleton
public class PublicUriForObjectInfo
implements Function<ObjectInfo, URI> {
    private final LoadingCache<String, URI> cdnContainer;

    @Inject
    public PublicUriForObjectInfo(LoadingCache<String, URI> cdnContainer) {
        this.cdnContainer = cdnContainer;
    }

    public URI apply(ObjectInfo from) {
        if (from == null) {
            return null;
        }
        try {
            return Uris.uriBuilder((URI)((URI)this.cdnContainer.getUnchecked((Object)from.getContainer()))).clearQuery().appendPath(from.getName()).build();
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            return null;
        }
    }
}

