/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.KeystoneAsyncApi;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneParserModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneRestClientModule;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;

public class KeystoneApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = 6725672099385580694L;
    public static final TypeToken<RestContext<? extends KeystoneApi, ? extends KeystoneAsyncApi>> CONTEXT_TOKEN = new TypeToken<RestContext<? extends KeystoneApi, ? extends KeystoneAsyncApi>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    public Builder toBuilder() {
        return new Builder(this.getApi(), this.getAsyncApi()).fromApiMetadata((ApiMetadata)this);
    }

    public KeystoneApiMetadata() {
        this(new Builder(KeystoneApi.class, KeystoneAsyncApi.class));
    }

    protected KeystoneApiMetadata(Builder builder) {
        super((BaseRestApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        properties.setProperty("jclouds.keystone.service-type", "identity");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder(Class<?> api, Class<?> asyncApi) {
            super(api, asyncApi);
            this.id("openstack-keystone").name("OpenStack Keystone Essex+ API").identityName("${tenantName}:${userName} or ${userName}, if your keystone supports a default tenant").credentialName("${password}").endpointName("KeyStone base url ending in /v${jclouds.api-version}/").documentation(URI.create("http://api.openstack.org/")).version("2.0").defaultEndpoint("http://localhost:5000/v${jclouds.api-version}/").defaultProperties(KeystoneApiMetadata.defaultProperties()).defaultModules((Set)ImmutableSet.builder().add(KeystoneAuthenticationModule.class).add(KeystoneRestClientModule.KeystoneAdminURLModule.class).add(KeystoneParserModule.class).add(KeystoneRestClientModule.class).build());
        }

        public KeystoneApiMetadata build() {
            return new KeystoneApiMetadata(this);
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

