/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.domain.Service;
import org.jclouds.openstack.keystone.v2_0.domain.Token;
import org.jclouds.openstack.keystone.v2_0.domain.User;

public class Access
extends ForwardingSet<Service>
implements Comparable<Access> {
    private final Token token;
    private final User user;
    private final Set<Service> serviceCatalog;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromAccess(this);
    }

    @ConstructorProperties(value={"token", "user", "serviceCatalog"})
    protected Access(Token token, User user, @Nullable Set<Service> serviceCatalog) {
        this.token = (Token)Preconditions.checkNotNull((Object)token, (Object)"token");
        this.user = (User)((Object)Preconditions.checkNotNull((Object)((Object)user), (Object)"user"));
        this.serviceCatalog = serviceCatalog == null ? ImmutableSet.of() : ImmutableSet.copyOf(serviceCatalog);
    }

    public Token getToken() {
        return this.token;
    }

    public User getUser() {
        return this.user;
    }

    @Deprecated
    public Set<Service> getServiceCatalog() {
        return this.serviceCatalog;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.token, this.user, this.serviceCatalog});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Access that = (Access)Access.class.cast(obj);
        return Objects.equal((Object)this.token, (Object)that.token) && Objects.equal((Object)((Object)this.user), (Object)((Object)that.user)) && Objects.equal(this.serviceCatalog, that.serviceCatalog);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("token", (Object)this.token).add("user", (Object)this.user).add("serviceCatalog", this.serviceCatalog);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Access that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.token.compareTo(that.token);
    }

    protected Set<Service> delegate() {
        return this.serviceCatalog;
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected Token token;
        protected User user;
        protected ImmutableSet.Builder<Service> serviceCatalog = ImmutableSet.builder();

        protected abstract T self();

        public T token(Token token) {
            this.token = token;
            return this.self();
        }

        public T user(User user) {
            this.user = user;
            return this.self();
        }

        public T service(Service service) {
            this.serviceCatalog.add((Object)service);
            return this.self();
        }

        public T services(Iterable<Service> serviceCatalog) {
            this.serviceCatalog.addAll(serviceCatalog);
            return this.self();
        }

        @Deprecated
        public T serviceCatalog(Set<Service> serviceCatalog) {
            this.serviceCatalog.addAll(serviceCatalog);
            return this.self();
        }

        @Deprecated
        public T serviceCatalog(Service ... in) {
            return this.serviceCatalog((Set<Service>)ImmutableSet.copyOf((Object[])in));
        }

        public Access build() {
            return new Access(this.token, this.user, (Set<Service>)this.serviceCatalog.build());
        }

        public T fromAccess(Access in) {
            return ((Builder)((Builder)this.token(in.getToken())).user(in.getUser())).services((Iterable<Service>)((Object)in));
        }
    }
}

