/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.walrus;

import com.google.common.collect.ImmutableSet;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.s3.S3ApiMetadata;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.blobstore.config.S3BlobStoreContextModule;
import org.jclouds.walrus.config.WalrusRestClientModule;

public class WalrusApiMetadata
extends S3ApiMetadata {
    private static final long serialVersionUID = 820062881469203616L;

    private static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return WalrusApiMetadata.builder().fromApiMetadata((ApiMetadata)this);
    }

    public WalrusApiMetadata() {
        this(WalrusApiMetadata.builder());
    }

    protected WalrusApiMetadata(Builder builder) {
        super((S3ApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = S3ApiMetadata.defaultProperties();
        properties.setProperty("jclouds.s3.service-path", "/services/Walrus");
        properties.setProperty("jclouds.s3.virtual-host-buckets", "false");
        return properties;
    }

    public static class Builder
    extends S3ApiMetadata.Builder {
        protected Builder() {
            super(S3Client.class, S3AsyncClient.class);
            this.id("walrus").name("Walrus (S3 clone) API").version("Walrus-1.6").defaultProperties(WalrusApiMetadata.defaultProperties()).defaultModules((Set)ImmutableSet.of(WalrusRestClientModule.class, S3BlobStoreContextModule.class));
        }

        public WalrusApiMetadata build() {
            return new WalrusApiMetadata(this);
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

