/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.date.DateService;
import org.jclouds.http.options.GetOptions;
import org.jclouds.util.Strings2;

@Singleton
public class HttpGetOptionsListToGetOptions
implements Function<GetOptions[], org.jclouds.blobstore.options.GetOptions> {
    private final DateService dateService;

    @Inject
    HttpGetOptionsListToGetOptions(DateService dateService) {
        this.dateService = (DateService)Preconditions.checkNotNull((Object)dateService, (Object)"dateService");
    }

    public org.jclouds.blobstore.options.GetOptions apply(GetOptions[] from) {
        Preconditions.checkNotNull((Object)from, (Object)"options");
        org.jclouds.blobstore.options.GetOptions to = new org.jclouds.blobstore.options.GetOptions();
        if (from.length != 0) {
            Date time;
            if (from[0].getIfMatch() != null) {
                to.ifETagMatches(Strings2.replaceAll((String)from[0].getIfMatch(), (char)'\"', (String)""));
            }
            if (from[0].getIfModifiedSince() != null) {
                time = this.dateService.rfc822DateParse(from[0].getIfModifiedSince());
                to.ifModifiedSince(time);
            }
            if (from[0].getIfNoneMatch() != null) {
                to.ifETagDoesntMatch(Strings2.replaceAll((String)from[0].getIfNoneMatch(), (char)'\"', (String)""));
            }
            if (from[0].getIfUnmodifiedSince() != null) {
                time = this.dateService.rfc822DateParse(from[0].getIfUnmodifiedSince());
                to.ifUnmodifiedSince(time);
            }
            for (String range : from[0].getRanges()) {
                String[] firstLast = range.split("\\-");
                to.range(Long.parseLong(firstLast[0]), Long.parseLong(firstLast[1]));
            }
        }
        return to;
    }
}

