/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.options;

public class PutOptions
implements Cloneable {
    public static final ImmutablePutOptions NONE = new ImmutablePutOptions(new PutOptions());
    private boolean multipart = false;

    public PutOptions() {
    }

    public PutOptions(boolean multipart) {
        this.multipart = multipart;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public PutOptions multipart() {
        return this.multipart(true);
    }

    public PutOptions multipart(boolean val) {
        this.multipart = val;
        return this;
    }

    public PutOptions clone() {
        return new PutOptions(this.multipart);
    }

    public String toString() {
        return "[multipart=" + this.multipart + "]";
    }

    public static class Builder {
        public static PutOptions fromPutOptions(PutOptions putOptions) {
            return Builder.multipart(putOptions.multipart);
        }

        public static PutOptions multipart() {
            return Builder.multipart(true);
        }

        public static PutOptions multipart(boolean val) {
            PutOptions options = new PutOptions();
            return options.multipart(val);
        }
    }

    public static class ImmutablePutOptions
    extends PutOptions {
        private final PutOptions delegate;

        public ImmutablePutOptions(PutOptions delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isMultipart() {
            return this.delegate.isMultipart();
        }

        @Override
        public PutOptions multipart() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PutOptions clone() {
            return this.delegate.clone();
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }
    }
}

