/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.internal.BlobRuntimeException;
import org.jclouds.blobstore.reference.BlobStoreConstants;
import org.jclouds.blobstore.strategy.DeleteDirectoryStrategy;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;

@Singleton
public class MarkersDeleteDirectoryStrategy
implements DeleteDirectoryStrategy {
    private final AsyncBlobStore ablobstore;
    private final BlobStore blobstore;
    private final ExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime;

    @Inject
    MarkersDeleteDirectoryStrategy(@Named(value="jclouds.user-threads") ExecutorService userExecutor, AsyncBlobStore ablobstore, BlobStore blobstore) {
        this.userExecutor = userExecutor;
        this.ablobstore = ablobstore;
        this.blobstore = blobstore;
    }

    @Override
    public void execute(String containerName, String directory) {
        Map exceptions;
        HashSet names = Sets.newHashSet();
        names.add(directory);
        for (String suffix : BlobStoreConstants.DIRECTORY_SUFFIXES) {
            names.add(directory + suffix);
        }
        HashMap responses = Maps.newHashMap();
        for (String name : names) {
            responses.put(name, this.ablobstore.removeBlob(containerName, name));
        }
        String message = String.format("deleting directory %s in containerName: %s", directory, containerName);
        try {
            exceptions = FutureIterables.awaitCompletion((Map)responses, (ExecutorService)this.userExecutor, (Long)this.maxTime, (Logger)this.logger, (String)message);
        }
        catch (TimeoutException te) {
            throw Throwables.propagate((Throwable)te);
        }
        if (exceptions.size() > 0) {
            throw new BlobRuntimeException(String.format("error %s: %s", message, exceptions));
        }
        assert (!this.blobstore.directoryExists(containerName, directory)) : String.format("still exists %s: %s", message, exceptions);
    }
}

