/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.internal.BlobRuntimeException;
import org.jclouds.blobstore.strategy.PutBlobsStrategy;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;

@Singleton
public class PutBlobsStrategyImpl
implements PutBlobsStrategy {
    private final AsyncBlobStore ablobstore;
    private final ExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime;

    @Inject
    PutBlobsStrategyImpl(@Named(value="jclouds.user-threads") ExecutorService userExecutor, AsyncBlobStore ablobstore) {
        this.userExecutor = userExecutor;
        this.ablobstore = ablobstore;
    }

    @Override
    public void execute(String containerName, Iterable<? extends Blob> blobs) {
        Map exceptions;
        LinkedHashMap responses = Maps.newLinkedHashMap();
        for (Blob blob : blobs) {
            responses.put(blob, this.ablobstore.putBlob(containerName, blob));
        }
        try {
            exceptions = FutureIterables.awaitCompletion((Map)responses, (ExecutorService)this.userExecutor, (Long)this.maxTime, (Logger)this.logger, (String)String.format("putting into containerName: %s", containerName));
        }
        catch (TimeoutException timeoutException) {
            throw Throwables.propagate((Throwable)timeoutException);
        }
        if (exceptions.size() > 0) {
            throw new BlobRuntimeException(String.format("error putting into container %s: %s", containerName, exceptions));
        }
    }
}

