/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.jclouds.rest.config.AsyncClientProvider;
import org.jclouds.rest.config.ClientProvider;

public class BinderUtils {
    public static <S, A> void bindClientAndAsyncClient(Binder binder, Class<?> syncClientType, Class<?> asyncClientType) {
        BinderUtils.bindClientAndAsyncClient(binder, syncClientType, asyncClientType, ImmutableMap.of());
    }

    public static <S, A> void bindClientAndAsyncClient(Binder binder, Class<?> syncClientType, Class<?> asyncClientType, Map<Class<?>, Class<?>> sync2Async) {
        BinderUtils.bindClient(binder, syncClientType, asyncClientType, sync2Async);
        BinderUtils.bindAsyncClient(binder, asyncClientType);
    }

    public static <K, V> void bindClient(Binder binder, Class<K> syncClientType, Class<V> asyncClientType, Map<Class<?>, Class<?>> sync2Async) {
        ClientProvider asyncProvider = new ClientProvider(syncClientType, asyncClientType, sync2Async);
        binder.requestInjection(asyncProvider);
        binder.bind(syncClientType).toProvider(asyncProvider);
    }

    public static <T> void bindAsyncClient(Binder binder, Class<T> asyncClientType) {
        AsyncClientProvider asyncProvider = new AsyncClientProvider(asyncClientType);
        binder.requestInjection(asyncProvider);
        binder.bind(asyncClientType).toProvider(asyncProvider);
    }

    public static <T> T newNullProxy(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        });
    }
}

