/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.io.OutputSupplier;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.jclouds.util.Throwables2;

public class Suppliers2 {
    public static <K, V> Supplier<V> valueForKey(final Supplier<Map<K, Supplier<V>>> input, final Supplier<K> key) {
        return new Supplier<V>(){

            public V get() {
                Object keyToFind = key.get();
                Supplier value = (Supplier)((Map)input.get()).get(keyToFind);
                return value != null ? value.get() : null;
            }

            public String toString() {
                return "withKey()";
            }
        };
    }

    public static <K, V> Supplier<V> getLastValueInMap(final Supplier<Map<K, Supplier<V>>> input) {
        return new Supplier<V>(){

            public V get() {
                Supplier last = (Supplier)Iterables.getLast(((Map)input.get()).values());
                return last != null ? last.get() : null;
            }

            public String toString() {
                return "getLastValueInMap()";
            }
        };
    }

    public static <X> Function<X, Supplier<X>> ofInstanceFunction() {
        return new Function<X, Supplier<X>>(){

            public Supplier<X> apply(X arg0) {
                return Suppliers.ofInstance(arg0);
            }

            public String toString() {
                return "Suppliers.ofInstance()";
            }
        };
    }

    public static OutputSupplier<OutputStream> newOutputStreamSupplier(final OutputStream output) {
        Preconditions.checkNotNull((Object)output, (Object)"output");
        return new OutputSupplier<OutputStream>(){

            public OutputStream getOutput() throws IOException {
                return output;
            }
        };
    }

    @Beta
    public static <T> Supplier<T> or(final Supplier<T> unlessNull, final Supplier<T> fallback) {
        return new Supplier<T>(){

            public T get() {
                Object val = unlessNull.get();
                if (val != null) {
                    return val;
                }
                return fallback.get();
            }

            public String toString() {
                return Objects.toStringHelper((Object)this).add("unlessNull", (Object)unlessNull).add("fallback", (Object)fallback).toString();
            }
        };
    }

    @Beta
    public static <T, X extends Throwable> Supplier<T> onThrowable(final Supplier<T> unlessThrowable, final Class<X> throwable, final Supplier<T> fallback) {
        return new Supplier<T>(){

            public T get() {
                try {
                    return unlessThrowable.get();
                }
                catch (Throwable t) {
                    if (Throwables2.getFirstThrowableOfType(t, throwable) != null) {
                        return fallback.get();
                    }
                    throw Throwables.propagate((Throwable)t);
                }
            }

            public String toString() {
                return Objects.toStringHelper((Object)this).add("unlessThrowable", (Object)unlessThrowable).add("throwable", (Object)throwable.getSimpleName()).add("fallback", (Object)fallback).toString();
            }
        };
    }

    public static <F, T> Supplier<T> compose(Function<? super F, T> function, Supplier<F> supplier) {
        Preconditions.checkNotNull(function);
        Preconditions.checkNotNull(supplier);
        return new SupplierComposition<F, T>(function, supplier);
    }

    private static class SupplierComposition<F, T>
    implements Supplier<T>,
    Serializable {
        private static final long serialVersionUID = 1023509665531743802L;
        final Function<? super F, T> function;
        final Supplier<F> supplier;

        SupplierComposition(Function<? super F, T> function, Supplier<F> supplier) {
            this.function = function;
            this.supplier = supplier;
        }

        public T get() {
            return (T)this.function.apply(this.supplier.get());
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("function", this.function).add("supplier", this.supplier).toString();
        }
    }
}

