// $ANTLR 3.4 org/jdbi/v3/core/internal/lexer/HashStatementLexer.g 2017-11-23 11:32:47

    package org.jdbi.v3.core.internal.lexer;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings({"all", "warnings", "unchecked"})
public class HashStatementLexer extends Lexer {
    public static final int EOF=-1;
    public static final int COMMENT=4;
    public static final int DOUBLE_QUOTE=5;
    public static final int DOUBLE_QUOTED_TEXT=6;
    public static final int ESCAPE=7;
    public static final int ESCAPED_TEXT=8;
    public static final int ESCAPE_QUOTE=9;
    public static final int HASH=10;
    public static final int LITERAL=11;
    public static final int NAME=12;
    public static final int NAMED_PARAM=13;
    public static final int POSITIONAL_PARAM=14;
    public static final int QUOTE=15;
    public static final int QUOTED_TEXT=16;

      @Override
      public void reportError(RecognitionException e) {
        throw new IllegalArgumentException(e);
      }


    // delegates
    // delegators
    public Lexer[] getDelegates() {
        return new Lexer[] {};
    }

    public HashStatementLexer() {} 
    public HashStatementLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public HashStatementLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);
    }
    public String getGrammarFileName() { return "org/jdbi/v3/core/internal/lexer/HashStatementLexer.g"; }

    // $ANTLR start "QUOTE"
    public final void mQUOTE() throws RecognitionException {
        try {
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:14:15: ( '\\'' )
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:14:17: '\\''
            {
            match('\''); 

            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "QUOTE"

    // $ANTLR start "ESCAPE"
    public final void mESCAPE() throws RecognitionException {
        try {
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:15:16: ( '\\\\' )
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:15:18: '\\\\'
            {
            match('\\'); 

            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ESCAPE"

    // $ANTLR start "ESCAPE_QUOTE"
    public final void mESCAPE_QUOTE() throws RecognitionException {
        try {
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:16:22: ( ESCAPE QUOTE )
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:16:24: ESCAPE QUOTE
            {
            mESCAPE(); 


            mQUOTE(); 


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ESCAPE_QUOTE"

    // $ANTLR start "DOUBLE_QUOTE"
    public final void mDOUBLE_QUOTE() throws RecognitionException {
        try {
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:17:22: ( '\"' )
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:17:24: '\"'
            {
            match('\"'); 

            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "DOUBLE_QUOTE"

    // $ANTLR start "HASH"
    public final void mHASH() throws RecognitionException {
        try {
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:18:14: ( '#' )
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:18:16: '#'
            {
            match('#'); 

            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "HASH"

    // $ANTLR start "NAME"
    public final void mNAME() throws RecognitionException {
        try {
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:19:14: ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '_' | '.' | ':' )
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:
            {
            if ( input.LA(1)=='.'||(input.LA(1) >= '0' && input.LA(1) <= ':')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z') ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "NAME"

    // $ANTLR start "COMMENT"
    public final void mCOMMENT() throws RecognitionException {
        try {
            int _type = COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:21:8: ( '/*' ( . )* '*/' )
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:21:10: '/*' ( . )* '*/'
            {
            match("/*"); 



            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:21:15: ( . )*
            loop1:
            do {
                int alt1=2;
                int LA1_0 = input.LA(1);

                if ( (LA1_0=='*') ) {
                    int LA1_1 = input.LA(2);

                    if ( (LA1_1=='/') ) {
                        alt1=2;
                    }
                    else if ( ((LA1_1 >= '\u0000' && LA1_1 <= '.')||(LA1_1 >= '0' && LA1_1 <= '\uFFFF')) ) {
                        alt1=1;
                    }


                }
                else if ( ((LA1_0 >= '\u0000' && LA1_0 <= ')')||(LA1_0 >= '+' && LA1_0 <= '\uFFFF')) ) {
                    alt1=1;
                }


                switch (alt1) {
            	case 1 :
            	    // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:21:15: .
            	    {
            	    matchAny(); 

            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);


            match("*/"); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "COMMENT"

    // $ANTLR start "QUOTED_TEXT"
    public final void mQUOTED_TEXT() throws RecognitionException {
        try {
            int _type = QUOTED_TEXT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:22:12: ( QUOTE ( ESCAPE_QUOTE |~ QUOTE )* QUOTE )
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:22:14: QUOTE ( ESCAPE_QUOTE |~ QUOTE )* QUOTE
            {
            mQUOTE(); 


            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:22:20: ( ESCAPE_QUOTE |~ QUOTE )*
            loop2:
            do {
                int alt2=3;
                int LA2_0 = input.LA(1);

                if ( (LA2_0=='\\') ) {
                    int LA2_2 = input.LA(2);

                    if ( (LA2_2=='\'') ) {
                        int LA2_4 = input.LA(3);

                        if ( ((LA2_4 >= '\u0000' && LA2_4 <= '\uFFFF')) ) {
                            alt2=1;
                        }

                        else {
                            alt2=2;
                        }


                    }
                    else if ( ((LA2_2 >= '\u0000' && LA2_2 <= '&')||(LA2_2 >= '(' && LA2_2 <= '\uFFFF')) ) {
                        alt2=2;
                    }


                }
                else if ( ((LA2_0 >= '\u0000' && LA2_0 <= '&')||(LA2_0 >= '(' && LA2_0 <= '[')||(LA2_0 >= ']' && LA2_0 <= '\uFFFF')) ) {
                    alt2=2;
                }


                switch (alt2) {
            	case 1 :
            	    // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:22:21: ESCAPE_QUOTE
            	    {
            	    mESCAPE_QUOTE(); 


            	    }
            	    break;
            	case 2 :
            	    // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:22:36: ~ QUOTE
            	    {
            	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\u000E')||(input.LA(1) >= '\u0010' && input.LA(1) <= '\uFFFF') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);


            mQUOTE(); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "QUOTED_TEXT"

    // $ANTLR start "DOUBLE_QUOTED_TEXT"
    public final void mDOUBLE_QUOTED_TEXT() throws RecognitionException {
        try {
            int _type = DOUBLE_QUOTED_TEXT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:23:19: ( DOUBLE_QUOTE (~ DOUBLE_QUOTE )+ DOUBLE_QUOTE )
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:23:21: DOUBLE_QUOTE (~ DOUBLE_QUOTE )+ DOUBLE_QUOTE
            {
            mDOUBLE_QUOTE(); 


            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:23:34: (~ DOUBLE_QUOTE )+
            int cnt3=0;
            loop3:
            do {
                int alt3=2;
                int LA3_0 = input.LA(1);

                if ( ((LA3_0 >= '\u0000' && LA3_0 <= '!')||(LA3_0 >= '#' && LA3_0 <= '\uFFFF')) ) {
                    alt3=1;
                }


                switch (alt3) {
            	case 1 :
            	    // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:
            	    {
            	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '!')||(input.LA(1) >= '#' && input.LA(1) <= '\uFFFF') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt3 >= 1 ) break loop3;
                        EarlyExitException eee =
                            new EarlyExitException(3, input);
                        throw eee;
                }
                cnt3++;
            } while (true);


            mDOUBLE_QUOTE(); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "DOUBLE_QUOTED_TEXT"

    // $ANTLR start "ESCAPED_TEXT"
    public final void mESCAPED_TEXT() throws RecognitionException {
        try {
            int _type = ESCAPED_TEXT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:24:14: ( ESCAPE . )
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:24:16: ESCAPE .
            {
            mESCAPE(); 


            matchAny(); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ESCAPED_TEXT"

    // $ANTLR start "NAMED_PARAM"
    public final void mNAMED_PARAM() throws RecognitionException {
        try {
            int _type = NAMED_PARAM;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:26:12: ( HASH ( NAME )+ )
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:26:14: HASH ( NAME )+
            {
            mHASH(); 


            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:26:19: ( NAME )+
            int cnt4=0;
            loop4:
            do {
                int alt4=2;
                switch ( input.LA(1) ) {
                case '.':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case ':':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '_':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':
                    {
                    alt4=1;
                    }
                    break;

                }

                switch (alt4) {
            	case 1 :
            	    // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:
            	    {
            	    if ( input.LA(1)=='.'||(input.LA(1) >= '0' && input.LA(1) <= ':')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt4 >= 1 ) break loop4;
                        EarlyExitException eee =
                            new EarlyExitException(4, input);
                        throw eee;
                }
                cnt4++;
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "NAMED_PARAM"

    // $ANTLR start "POSITIONAL_PARAM"
    public final void mPOSITIONAL_PARAM() throws RecognitionException {
        try {
            int _type = POSITIONAL_PARAM;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:27:17: ( '?' )
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:27:19: '?'
            {
            match('?'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "POSITIONAL_PARAM"

    // $ANTLR start "LITERAL"
    public final void mLITERAL() throws RecognitionException {
        try {
            int _type = LITERAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:29:8: ( ( NAME | ' ' | '\\t' | '\\n' | '\\r' | ',' | '@' | '!' | '=' | ';' | '(' | ')' | '[' | ']' | '+' | '-' | '>' | '<' | '%' | '&' | '^' | '|' | '$' | '~' | '{' | '}' | '`' )+ | '*' | '/' )
            int alt6=3;
            switch ( input.LA(1) ) {
            case '\t':
            case '\n':
            case '\r':
            case ' ':
            case '!':
            case '$':
            case '%':
            case '&':
            case '(':
            case ')':
            case '+':
            case ',':
            case '-':
            case '.':
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
            case ':':
            case ';':
            case '<':
            case '=':
            case '>':
            case '@':
            case 'A':
            case 'B':
            case 'C':
            case 'D':
            case 'E':
            case 'F':
            case 'G':
            case 'H':
            case 'I':
            case 'J':
            case 'K':
            case 'L':
            case 'M':
            case 'N':
            case 'O':
            case 'P':
            case 'Q':
            case 'R':
            case 'S':
            case 'T':
            case 'U':
            case 'V':
            case 'W':
            case 'X':
            case 'Y':
            case 'Z':
            case '[':
            case ']':
            case '^':
            case '_':
            case '`':
            case 'a':
            case 'b':
            case 'c':
            case 'd':
            case 'e':
            case 'f':
            case 'g':
            case 'h':
            case 'i':
            case 'j':
            case 'k':
            case 'l':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 'r':
            case 's':
            case 't':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            case 'y':
            case 'z':
            case '{':
            case '|':
            case '}':
            case '~':
                {
                alt6=1;
                }
                break;
            case '*':
                {
                alt6=2;
                }
                break;
            case '/':
                {
                alt6=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;

            }

            switch (alt6) {
                case 1 :
                    // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:29:10: ( NAME | ' ' | '\\t' | '\\n' | '\\r' | ',' | '@' | '!' | '=' | ';' | '(' | ')' | '[' | ']' | '+' | '-' | '>' | '<' | '%' | '&' | '^' | '|' | '$' | '~' | '{' | '}' | '`' )+
                    {
                    // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:29:10: ( NAME | ' ' | '\\t' | '\\n' | '\\r' | ',' | '@' | '!' | '=' | ';' | '(' | ')' | '[' | ']' | '+' | '-' | '>' | '<' | '%' | '&' | '^' | '|' | '$' | '~' | '{' | '}' | '`' )+
                    int cnt5=0;
                    loop5:
                    do {
                        int alt5=2;
                        switch ( input.LA(1) ) {
                        case '\t':
                        case '\n':
                        case '\r':
                        case ' ':
                        case '!':
                        case '$':
                        case '%':
                        case '&':
                        case '(':
                        case ')':
                        case '+':
                        case ',':
                        case '-':
                        case '.':
                        case '0':
                        case '1':
                        case '2':
                        case '3':
                        case '4':
                        case '5':
                        case '6':
                        case '7':
                        case '8':
                        case '9':
                        case ':':
                        case ';':
                        case '<':
                        case '=':
                        case '>':
                        case '@':
                        case 'A':
                        case 'B':
                        case 'C':
                        case 'D':
                        case 'E':
                        case 'F':
                        case 'G':
                        case 'H':
                        case 'I':
                        case 'J':
                        case 'K':
                        case 'L':
                        case 'M':
                        case 'N':
                        case 'O':
                        case 'P':
                        case 'Q':
                        case 'R':
                        case 'S':
                        case 'T':
                        case 'U':
                        case 'V':
                        case 'W':
                        case 'X':
                        case 'Y':
                        case 'Z':
                        case '[':
                        case ']':
                        case '^':
                        case '_':
                        case '`':
                        case 'a':
                        case 'b':
                        case 'c':
                        case 'd':
                        case 'e':
                        case 'f':
                        case 'g':
                        case 'h':
                        case 'i':
                        case 'j':
                        case 'k':
                        case 'l':
                        case 'm':
                        case 'n':
                        case 'o':
                        case 'p':
                        case 'q':
                        case 'r':
                        case 's':
                        case 't':
                        case 'u':
                        case 'v':
                        case 'w':
                        case 'x':
                        case 'y':
                        case 'z':
                        case '{':
                        case '|':
                        case '}':
                        case '~':
                            {
                            alt5=1;
                            }
                            break;

                        }

                        switch (alt5) {
                    	case 1 :
                    	    // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:
                    	    {
                    	    if ( (input.LA(1) >= '\t' && input.LA(1) <= '\n')||input.LA(1)=='\r'||(input.LA(1) >= ' ' && input.LA(1) <= '!')||(input.LA(1) >= '$' && input.LA(1) <= '&')||(input.LA(1) >= '(' && input.LA(1) <= ')')||(input.LA(1) >= '+' && input.LA(1) <= '.')||(input.LA(1) >= '0' && input.LA(1) <= '>')||(input.LA(1) >= '@' && input.LA(1) <= '[')||(input.LA(1) >= ']' && input.LA(1) <= '~') ) {
                    	        input.consume();
                    	    }
                    	    else {
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    if ( cnt5 >= 1 ) break loop5;
                                EarlyExitException eee =
                                    new EarlyExitException(5, input);
                                throw eee;
                        }
                        cnt5++;
                    } while (true);


                    }
                    break;
                case 2 :
                    // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:30:92: '*'
                    {
                    match('*'); 

                    }
                    break;
                case 3 :
                    // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:30:98: '/'
                    {
                    match('/'); 

                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LITERAL"

    public void mTokens() throws RecognitionException {
        // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:1:8: ( COMMENT | QUOTED_TEXT | DOUBLE_QUOTED_TEXT | ESCAPED_TEXT | NAMED_PARAM | POSITIONAL_PARAM | LITERAL )
        int alt7=7;
        switch ( input.LA(1) ) {
        case '/':
            {
            switch ( input.LA(2) ) {
            case '*':
                {
                alt7=1;
                }
                break;
            default:
                alt7=7;
            }

            }
            break;
        case '\'':
            {
            alt7=2;
            }
            break;
        case '\"':
            {
            alt7=3;
            }
            break;
        case '\\':
            {
            alt7=4;
            }
            break;
        case '#':
            {
            alt7=5;
            }
            break;
        case '?':
            {
            alt7=6;
            }
            break;
        case '\t':
        case '\n':
        case '\r':
        case ' ':
        case '!':
        case '$':
        case '%':
        case '&':
        case '(':
        case ')':
        case '*':
        case '+':
        case ',':
        case '-':
        case '.':
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case ':':
        case ';':
        case '<':
        case '=':
        case '>':
        case '@':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '[':
        case ']':
        case '^':
        case '_':
        case '`':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':
        case '{':
        case '|':
        case '}':
        case '~':
            {
            alt7=7;
            }
            break;
        default:
            NoViableAltException nvae =
                new NoViableAltException("", 7, 0, input);

            throw nvae;

        }

        switch (alt7) {
            case 1 :
                // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:1:10: COMMENT
                {
                mCOMMENT(); 


                }
                break;
            case 2 :
                // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:1:18: QUOTED_TEXT
                {
                mQUOTED_TEXT(); 


                }
                break;
            case 3 :
                // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:1:30: DOUBLE_QUOTED_TEXT
                {
                mDOUBLE_QUOTED_TEXT(); 


                }
                break;
            case 4 :
                // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:1:49: ESCAPED_TEXT
                {
                mESCAPED_TEXT(); 


                }
                break;
            case 5 :
                // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:1:62: NAMED_PARAM
                {
                mNAMED_PARAM(); 


                }
                break;
            case 6 :
                // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:1:74: POSITIONAL_PARAM
                {
                mPOSITIONAL_PARAM(); 


                }
                break;
            case 7 :
                // org/jdbi/v3/core/internal/lexer/HashStatementLexer.g:1:91: LITERAL
                {
                mLITERAL(); 


                }
                break;

        }

    }


 

}