/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.jdbi.v3.core.internal.lexer.DefineStatementLexer;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

public class DefinedAttributeTemplateEngine
implements TemplateEngine {
    @Override
    public String render(String template, StatementContext ctx) {
        StringBuilder b = new StringBuilder();
        DefineStatementLexer lexer = new DefineStatementLexer((CharStream)new ANTLRStringStream(template));
        try {
            Token t = lexer.nextToken();
            while (t.getType() != -1) {
                switch (t.getType()) {
                    case 4: 
                    case 7: 
                    case 12: 
                    case 16: {
                        b.append(t.getText());
                        break;
                    }
                    case 5: {
                        String text = t.getText();
                        String key = text.substring(1, text.length() - 1);
                        Object value = ctx.getAttribute(key);
                        if (value == null) {
                            throw new UnableToCreateStatementException("Undefined attribute for token '" + text + "'", ctx);
                        }
                        b.append(value);
                        break;
                    }
                    case 9: {
                        b.append(t.getText().substring(1));
                        break;
                    }
                }
                t = lexer.nextToken();
            }
            return b.toString();
        }
        catch (RuntimeException e) {
            throw new UnableToCreateStatementException("Error rendering SQL template: '" + template + "'", e, ctx);
        }
    }
}

