/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.converter;

import java.util.Date;
import java.util.GregorianCalendar;
import org.jeasy.batch.core.converter.DateTypeConverter;
import org.jeasy.batch.core.converter.TypeConverter;
import org.jeasy.batch.core.util.Utils;

public class GregorianCalendarTypeConverter
implements TypeConverter<String, GregorianCalendar> {
    private DateTypeConverter dateTypeConverter;

    public GregorianCalendarTypeConverter() {
        this.dateTypeConverter = new DateTypeConverter();
    }

    public GregorianCalendarTypeConverter(String dateFormat) {
        this.dateTypeConverter = new DateTypeConverter(dateFormat);
    }

    @Override
    public GregorianCalendar convert(String value) {
        Utils.checkArgument(value != null, "Value to convert must not be null");
        Utils.checkArgument(!value.isEmpty(), "Value to convert must not be empty");
        Date date = this.dateTypeConverter.convert(value);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }
}

