/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.jmx;

import java.lang.management.ManagementFactory;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.jeasy.batch.core.jmx.JobMonitorMBean;
import org.jeasy.batch.core.job.Job;
import org.jeasy.batch.core.job.JobReport;
import org.jeasy.batch.core.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMonitor
extends NotificationBroadcasterSupport
implements JobMonitorMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JobMonitor.class.getName());
    private long sequenceNumber = 1L;
    private JobReport jobReport;

    public JobMonitor(JobReport jobReport) {
        this.jobReport = jobReport;
    }

    @Override
    public String getJobName() {
        return this.jobReport.getJobName();
    }

    @Override
    public long getReadCount() {
        return this.jobReport.getMetrics().getReadCount();
    }

    @Override
    public long getFilterCount() {
        return this.jobReport.getMetrics().getFilterCount();
    }

    @Override
    public long getErrorCount() {
        return this.jobReport.getMetrics().getErrorCount();
    }

    @Override
    public long getWriteCount() {
        return this.jobReport.getMetrics().getWriteCount();
    }

    @Override
    public String getStartTime() {
        return Utils.formatTime(this.jobReport.getMetrics().getStartTime());
    }

    @Override
    public String getEndTime() {
        return this.jobReport.getMetrics().getEndTime() == null ? "" : Utils.formatTime(this.jobReport.getMetrics().getEndTime());
    }

    @Override
    public String getJobStatus() {
        return this.jobReport.getStatus().name();
    }

    public void notifyJobReportUpdate() {
        AttributeChangeNotification notification = new AttributeChangeNotification(this, this.sequenceNumber++, Timestamp.valueOf(LocalDateTime.now()).getTime(), "job report updated", "JobReport", JobReport.class.getName(), null, this.jobReport);
        this.sendNotification(notification);
    }

    public void registerJmxMBeanFor(Job job) {
        LOGGER.debug("Registering JMX MBean for job '{}'", (Object)job.getName());
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = new ObjectName("org.jeasy.batch.jmx.monitor:name=" + job.getName());
            if (!mbs.isRegistered(name)) {
                mbs.registerMBean(this, name);
                LOGGER.debug("JMX MBean registered successfully as: {}", (Object)name.getCanonicalName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to register MBean for job '{}'", (Object)job.getName(), (Object)e);
        }
    }
}

