/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.job;

import org.jeasy.batch.core.filter.RecordFilter;
import org.jeasy.batch.core.job.BatchJob;
import org.jeasy.batch.core.job.Job;
import org.jeasy.batch.core.job.JobParameters;
import org.jeasy.batch.core.listener.BatchListener;
import org.jeasy.batch.core.listener.JobListener;
import org.jeasy.batch.core.listener.PipelineListener;
import org.jeasy.batch.core.listener.RecordReaderListener;
import org.jeasy.batch.core.listener.RecordWriterListener;
import org.jeasy.batch.core.mapper.RecordMapper;
import org.jeasy.batch.core.marshaller.RecordMarshaller;
import org.jeasy.batch.core.processor.RecordProcessor;
import org.jeasy.batch.core.reader.RecordReader;
import org.jeasy.batch.core.util.Utils;
import org.jeasy.batch.core.validator.RecordValidator;
import org.jeasy.batch.core.writer.RecordWriter;

public final class JobBuilder<I, O> {
    private BatchJob<I, O> job;
    private JobParameters parameters = new JobParameters();

    public JobBuilder() {
        this.job = new BatchJob(this.parameters);
    }

    public JobBuilder<I, O> named(String name) {
        Utils.checkNotNull(name, "job name");
        this.job.setName(name);
        return this;
    }

    public JobBuilder<I, O> reader(RecordReader<I> recordReader) {
        Utils.checkNotNull(recordReader, "record reader");
        this.job.setRecordReader(recordReader);
        return this;
    }

    public JobBuilder<I, O> filter(RecordFilter<?> recordFilter) {
        Utils.checkNotNull(recordFilter, "record filter");
        this.job.addRecordProcessor(recordFilter);
        return this;
    }

    public JobBuilder<I, O> mapper(RecordMapper<?, ?> recordMapper) {
        Utils.checkNotNull(recordMapper, "record mapper");
        this.job.addRecordProcessor(recordMapper);
        return this;
    }

    public JobBuilder<I, O> validator(RecordValidator<?> recordValidator) {
        Utils.checkNotNull(recordValidator, "record validator");
        this.job.addRecordProcessor(recordValidator);
        return this;
    }

    public JobBuilder<I, O> processor(RecordProcessor<?, ?> recordProcessor) {
        Utils.checkNotNull(recordProcessor, "record processor");
        this.job.addRecordProcessor(recordProcessor);
        return this;
    }

    public JobBuilder<I, O> marshaller(RecordMarshaller<?, ?> recordMarshaller) {
        Utils.checkNotNull(recordMarshaller, "record marshaller");
        this.job.addRecordProcessor(recordMarshaller);
        return this;
    }

    public JobBuilder<I, O> writer(RecordWriter<O> recordWriter) {
        Utils.checkNotNull(recordWriter, "record writer");
        this.job.setRecordWriter(recordWriter);
        return this;
    }

    public JobBuilder<I, O> errorThreshold(long errorThreshold) {
        Utils.checkArgument(errorThreshold >= 0L, "error threshold must be >= 0");
        this.parameters.setErrorThreshold(errorThreshold);
        return this;
    }

    public JobBuilder<I, O> enableJmx(boolean jmx) {
        this.parameters.setJmxMonitoring(jmx);
        return this;
    }

    public JobBuilder<I, O> enableBatchScanning(boolean batchScanning) {
        this.parameters.setBatchScanningEnabled(batchScanning);
        return this;
    }

    public JobBuilder<I, O> batchSize(int batchSize) {
        Utils.checkArgument(batchSize >= 1, "Batch size must be >= 1");
        this.parameters.setBatchSize(batchSize);
        return this;
    }

    public JobBuilder<I, O> jobListener(JobListener jobListener) {
        Utils.checkNotNull(jobListener, "job listener");
        this.job.addJobListener(jobListener);
        return this;
    }

    public JobBuilder<I, O> batchListener(BatchListener<O> batchListener) {
        Utils.checkNotNull(batchListener, "batch listener");
        this.job.addBatchListener(batchListener);
        return this;
    }

    public JobBuilder<I, O> readerListener(RecordReaderListener<I> recordReaderListener) {
        Utils.checkNotNull(recordReaderListener, "record reader listener");
        this.job.addRecordReaderListener(recordReaderListener);
        return this;
    }

    public JobBuilder<I, O> pipelineListener(PipelineListener pipelineListener) {
        Utils.checkNotNull(pipelineListener, "pipeline listener");
        this.job.addPipelineListener(pipelineListener);
        return this;
    }

    public JobBuilder<I, O> writerListener(RecordWriterListener<O> recordWriterListener) {
        Utils.checkNotNull(recordWriterListener, "record writer listener");
        this.job.addRecordWriterListener(recordWriterListener);
        return this;
    }

    public Job build() {
        return this.job;
    }
}

