/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jeasy.batch.core.listener.PipelineListener;
import org.jeasy.batch.core.record.Record;

public class CompositePipelineListener
implements PipelineListener {
    private List<PipelineListener> listeners;

    public CompositePipelineListener() {
        this(new ArrayList<PipelineListener>());
    }

    public CompositePipelineListener(List<PipelineListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public <P> Record<P> beforeRecordProcessing(Record<P> record) {
        Record<P> recordToProcess = record;
        for (PipelineListener listener : this.listeners) {
            recordToProcess = listener.beforeRecordProcessing(recordToProcess);
        }
        return recordToProcess;
    }

    @Override
    public <P> void afterRecordProcessing(Record<P> inputRecord, Record<P> outputRecord) {
        ListIterator<PipelineListener> iterator = this.listeners.listIterator(this.listeners.size());
        while (iterator.hasPrevious()) {
            iterator.previous().afterRecordProcessing(inputRecord, outputRecord);
        }
    }

    @Override
    public <P> void onRecordProcessingException(Record<P> record, Throwable throwable) {
        ListIterator<PipelineListener> iterator = this.listeners.listIterator(this.listeners.size());
        while (iterator.hasPrevious()) {
            iterator.previous().onRecordProcessingException(record, throwable);
        }
    }

    public void addPipelineListener(PipelineListener pipelineListener) {
        this.listeners.add(pipelineListener);
    }
}

