/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jeasy.batch.core.listener.RecordReaderListener;
import org.jeasy.batch.core.record.Record;

public class CompositeRecordReaderListener<P>
implements RecordReaderListener<P> {
    private List<RecordReaderListener<P>> listeners;

    public CompositeRecordReaderListener() {
        this(new ArrayList<RecordReaderListener<P>>());
    }

    public CompositeRecordReaderListener(List<RecordReaderListener<P>> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void beforeRecordReading() {
        for (RecordReaderListener<P> listener : this.listeners) {
            listener.beforeRecordReading();
        }
    }

    @Override
    public void afterRecordReading(Record<P> record) {
        ListIterator<RecordReaderListener<P>> iterator = this.listeners.listIterator(this.listeners.size());
        while (iterator.hasPrevious()) {
            iterator.previous().afterRecordReading(record);
        }
    }

    @Override
    public void onRecordReadingException(Throwable throwable) {
        ListIterator<RecordReaderListener<P>> iterator = this.listeners.listIterator(this.listeners.size());
        while (iterator.hasPrevious()) {
            iterator.previous().onRecordReadingException(throwable);
        }
    }

    public void addRecordReaderListener(RecordReaderListener<P> recordReaderListener) {
        this.listeners.add(recordReaderListener);
    }
}

