/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.processor;

import java.util.ArrayList;
import java.util.List;
import org.jeasy.batch.core.processor.RecordProcessor;
import org.jeasy.batch.core.record.Record;

public class CompositeRecordProcessor<I, O>
implements RecordProcessor<I, O> {
    private List<RecordProcessor<I, O>> processors;

    public CompositeRecordProcessor() {
        this(new ArrayList<RecordProcessor<I, O>>());
    }

    public CompositeRecordProcessor(List<RecordProcessor<I, O>> processors) {
        this.processors = processors;
    }

    @Override
    public Record<O> processRecord(Record<I> record) throws Exception {
        Record<Object> processedRecord = record;
        for (RecordProcessor<I, O> processor : this.processors) {
            processedRecord = processor.processRecord(processedRecord);
            if (processedRecord != null) continue;
            return null;
        }
        return processedRecord;
    }

    public void addRecordProcessor(RecordProcessor<I, O> recordProcessor) {
        this.processors.add(recordProcessor);
    }
}

