/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.reader;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import org.jeasy.batch.core.reader.AbstractFileRecordReader;
import org.jeasy.batch.core.reader.RecordReader;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.util.Utils;

public abstract class AbstractMultiFileRecordReader<P>
implements RecordReader<P> {
    protected List<Path> files;
    protected Path currentFile;
    protected AbstractFileRecordReader<P> delegate;
    protected Iterator<Path> iterator;
    protected Charset charset;

    public AbstractMultiFileRecordReader(List<Path> files) {
        this(files, Charset.defaultCharset());
    }

    public AbstractMultiFileRecordReader(List<Path> files, Charset charset) {
        Utils.checkNotNull(files, "files");
        Utils.checkNotNull(charset, "charset");
        this.files = files;
        this.charset = charset;
    }

    @Override
    public void open() throws Exception {
        this.iterator = this.files.iterator();
        this.currentFile = this.iterator.next();
        if (this.currentFile != null) {
            this.delegate = this.createReader();
            this.delegate.open();
        }
    }

    @Override
    public Record<P> readRecord() throws Exception {
        if (this.delegate == null) {
            return null;
        }
        Record record = this.delegate.readRecord();
        if (record == null) {
            this.delegate.close();
            if (this.iterator.hasNext()) {
                this.currentFile = this.iterator.next();
                this.delegate = this.createReader();
                this.delegate.open();
                return this.readRecord();
            }
        }
        return record;
    }

    @Override
    public void close() throws Exception {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    protected abstract AbstractFileRecordReader<P> createReader() throws Exception;
}

