/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.reader;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jeasy.batch.core.reader.RecordReader;
import org.jeasy.batch.core.record.Record;

public class BlockingQueueRecordReader<P>
implements RecordReader<P> {
    public static final long DEFAULT_TIMEOUT = 60000L;
    private BlockingQueue<Record<P>> queue;
    private long timeout;

    public BlockingQueueRecordReader(BlockingQueue<Record<P>> queue) {
        this(queue, 60000L);
    }

    public BlockingQueueRecordReader(BlockingQueue<Record<P>> queue, long timeout) {
        this.queue = queue;
        this.timeout = timeout;
    }

    @Override
    public Record<P> readRecord() throws Exception {
        return this.queue.poll(this.timeout, TimeUnit.MILLISECONDS);
    }
}

