/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.reader;

import java.time.LocalDateTime;
import java.util.Iterator;
import org.jeasy.batch.core.reader.RecordReader;
import org.jeasy.batch.core.record.GenericRecord;
import org.jeasy.batch.core.record.Header;
import org.jeasy.batch.core.util.Utils;

public class IterableRecordReader<P>
implements RecordReader<P> {
    private long currentRecordNumber;
    private Iterator<P> iterator;

    public IterableRecordReader(Iterable<P> dataSource) {
        Utils.checkNotNull(dataSource, "data source");
        this.iterator = dataSource.iterator();
    }

    @Override
    public void open() {
        this.currentRecordNumber = 0L;
    }

    @Override
    public GenericRecord<P> readRecord() {
        Header header = new Header(++this.currentRecordNumber, this.getDataSourceName(), LocalDateTime.now());
        if (this.iterator.hasNext()) {
            return new GenericRecord<P>(header, this.iterator.next());
        }
        return null;
    }

    private String getDataSourceName() {
        return "In-Memory Iterable";
    }
}

