/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.reader;

import java.util.concurrent.Callable;
import org.jeasy.batch.core.reader.RecordReader;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.retry.RetryPolicy;
import org.jeasy.batch.core.retry.RetryTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableRecordReader<P>
implements RecordReader<P> {
    private RecordReader<P> delegate;
    private RecordReadingCallable<P> recordReadingCallable;
    private RecordReadingTemplate recordReadingTemplate;

    public RetryableRecordReader(RecordReader<P> delegate, RetryPolicy retryPolicy) {
        this.delegate = delegate;
        this.recordReadingCallable = new RecordReadingCallable<P>(delegate);
        this.recordReadingTemplate = new RecordReadingTemplate(retryPolicy);
    }

    @Override
    public void open() throws Exception {
        this.delegate.open();
    }

    @Override
    public Record<P> readRecord() throws Exception {
        return (Record)this.recordReadingTemplate.execute(this.recordReadingCallable);
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    private static class RecordReadingTemplate
    extends RetryTemplate {
        private final Logger LOGGER = LoggerFactory.getLogger((String)RecordReadingTemplate.class.getName());

        RecordReadingTemplate(RetryPolicy retryPolicy) {
            super(retryPolicy);
        }

        @Override
        protected void beforeCall() {
        }

        @Override
        protected void afterCall(Object result) {
        }

        @Override
        protected void onException(Exception e) {
            this.LOGGER.error("Unable to read next record", (Throwable)e);
        }

        @Override
        protected void onMaxAttempts(Exception e) {
            this.LOGGER.error("Unable to read next record after {} attempt(s)", (Object)this.retryPolicy.getMaxAttempts());
        }

        @Override
        protected void beforeWait() {
            this.LOGGER.debug("Waiting for {} {} before retrying to read next record", (Object)this.retryPolicy.getDelay(), (Object)this.retryPolicy.getTimeUnit());
        }

        @Override
        protected void afterWait() {
        }
    }

    private static class RecordReadingCallable<P>
    implements Callable<Record<P>> {
        private RecordReader<P> recordReader;

        RecordReadingCallable(RecordReader<P> recordReader) {
            this.recordReader = recordReader;
        }

        @Override
        public Record<P> call() throws Exception {
            return this.recordReader.readRecord();
        }
    }
}

