/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.reader;

import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.stream.Stream;
import org.jeasy.batch.core.reader.RecordReader;
import org.jeasy.batch.core.record.GenericRecord;
import org.jeasy.batch.core.record.Header;
import org.jeasy.batch.core.record.Record;

public class StreamRecordReader<T>
implements RecordReader<T> {
    protected Stream<T> dataSource;
    protected Iterator<T> iterator;
    protected long currentRecordNumber;

    public StreamRecordReader(Stream<T> dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void open() {
        if (this.dataSource == null) {
            throw new IllegalArgumentException("The stream must not be null");
        }
        this.currentRecordNumber = 0L;
        this.iterator = this.dataSource.iterator();
    }

    @Override
    public Record<T> readRecord() {
        if (this.iterator.hasNext()) {
            Header header = new Header(++this.currentRecordNumber, this.getDataSourceName(), LocalDateTime.now());
            return new GenericRecord<T>(header, this.iterator.next());
        }
        return null;
    }

    private String getDataSourceName() {
        return "In-Memory Stream";
    }

    @Override
    public void close() {
        this.dataSource.close();
    }
}

