/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.writer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jeasy.batch.core.record.Batch;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.writer.RecordWriter;

public class BlockingQueueRecordWriter<P>
implements RecordWriter<P> {
    public static final long DEFAULT_TIMEOUT = 60000L;
    private BlockingQueue<Record<P>> blockingQueue;
    private long timeout;

    public BlockingQueueRecordWriter(BlockingQueue<Record<P>> blockingQueue) {
        this(blockingQueue, 60000L);
    }

    public BlockingQueueRecordWriter(BlockingQueue<Record<P>> blockingQueue, long timeout) {
        this.blockingQueue = blockingQueue;
        this.timeout = timeout;
    }

    @Override
    public void writeRecords(Batch<P> batch) throws Exception {
        for (Record<P> record : batch) {
            this.blockingQueue.offer(record, this.timeout, TimeUnit.MILLISECONDS);
        }
    }
}

