/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.writer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.jeasy.batch.core.record.Batch;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.util.Utils;
import org.jeasy.batch.core.writer.RecordWriter;

public class FileRecordWriter
implements RecordWriter<String> {
    private HeaderCallback headerCallback;
    private FooterCallback footerCallback;
    private Charset charset = Charset.defaultCharset();
    private String lineSeparator = Utils.LINE_SEPARATOR;
    private boolean append;
    private OutputStreamWriter outputStreamWriter;
    private Path path;

    public FileRecordWriter(Path path) {
        this.path = path;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public void setHeaderCallback(HeaderCallback headerCallback) {
        this.headerCallback = headerCallback;
    }

    public void setFooterCallback(FooterCallback footerCallback) {
        this.footerCallback = footerCallback;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    public void open() throws Exception {
        this.outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.path.toFile(), this.append), this.charset);
        if (this.headerCallback != null) {
            this.headerCallback.writeHeader(this.outputStreamWriter);
            this.outputStreamWriter.write(this.lineSeparator);
            this.outputStreamWriter.flush();
        }
    }

    @Override
    public void writeRecords(Batch<String> batch) throws Exception {
        for (Record<String> record : batch) {
            this.outputStreamWriter.write(record.getPayload());
            this.outputStreamWriter.write(this.lineSeparator);
        }
        this.outputStreamWriter.flush();
    }

    @Override
    public void close() throws Exception {
        if (this.footerCallback != null && this.outputStreamWriter != null) {
            this.footerCallback.writeFooter(this.outputStreamWriter);
            this.outputStreamWriter.write(this.lineSeparator);
            this.outputStreamWriter.flush();
        }
        if (this.outputStreamWriter != null) {
            this.outputStreamWriter.close();
        }
    }

    public static interface FooterCallback {
        public void writeFooter(OutputStreamWriter var1) throws IOException;
    }

    public static interface HeaderCallback {
        public void writeHeader(OutputStreamWriter var1) throws IOException;
    }
}

