/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.writer;

import java.io.StringWriter;
import org.jeasy.batch.core.record.Batch;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.util.Utils;
import org.jeasy.batch.core.writer.RecordWriter;

public class StringRecordWriter<P>
implements RecordWriter<P> {
    private StringWriter stringWriter;

    public StringRecordWriter(StringWriter stringWriter) {
        Utils.checkNotNull(stringWriter, "string writer");
        this.stringWriter = stringWriter;
    }

    @Override
    public void writeRecords(Batch<P> batch) {
        for (Record<P> record : batch) {
            this.stringWriter.write(record.getPayload().toString());
            this.stringWriter.write(Utils.LINE_SEPARATOR);
        }
        this.stringWriter.flush();
    }

    @Override
    public void close() throws Exception {
        this.stringWriter.close();
    }
}

